/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.plugins.prerelease;

import net.oneandone.maven.plugins.prerelease.Base;
import net.oneandone.maven.plugins.prerelease.core.Archive;
import net.oneandone.maven.plugins.prerelease.core.Descriptor;
import net.oneandone.maven.plugins.prerelease.core.Target;
import net.oneandone.maven.plugins.prerelease.core.WorkingCopy;
import net.oneandone.sushi.fs.file.FileNode;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class ProjectBase
extends Base {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(property="prerelease.checkoutLink", defaultValue="${basedir}/target/checkout")
    private String checkoutLink;
    protected Target target = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute() throws Exception {
        FileNode directory = Archive.directory(this.world.file(this.archiveRoot), this.project);
        try (Archive archive = Archive.open(directory, this.lockTimeout, this.getLog());){
            try {
                this.doExecute(archive);
            }
            finally {
                if (this.target != null) {
                    this.target.checkoutLinkOpt(this.checkoutLink);
                }
            }
            if (this.definesTarget() && this.target == null) {
                throw new IllegalStateException("missing target");
            }
        }
    }

    public abstract void doExecute(Archive var1) throws Exception;

    public void setTarget(Target t) {
        this.target = t;
    }

    protected boolean definesTarget() {
        return true;
    }

    public FileNode basedir() {
        return this.world.file(this.project.getBasedir());
    }

    protected WorkingCopy checkedWorkingCopy() throws Exception {
        Log log = this.getLog();
        log.info((CharSequence)"checking working copy ...");
        WorkingCopy workingCopy = WorkingCopy.load(this.basedir());
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("revisions: " + workingCopy.revisions));
            log.debug((CharSequence)("changes: " + workingCopy.changes));
        }
        workingCopy.check();
        return workingCopy;
    }

    protected Descriptor checkedDescriptor(WorkingCopy workingCopy) throws Exception {
        this.getLog().info((CharSequence)"checking project ...");
        long revision = workingCopy.revision();
        Descriptor descriptor = Descriptor.checkedCreate(this.world, this.project, revision);
        workingCopy.checkCompatibility(descriptor);
        return descriptor;
    }
}

