/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.rules.common;

import java.io.File;
import java.util.Objects;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public abstract class AbstractRule
extends AbstractNonCacheableEnforcerRule {
    protected boolean failureDetected = false;
    private String lastLogHeader = null;

    protected void logHeader(Log log, String type) {
        if (!Objects.equals(this.lastLogHeader, type)) {
            this.lastLogHeader = type;
            log.warn((CharSequence)(type + " findings of " + ((Object)((Object)this)).getClass().getSimpleName()));
            log.warn((CharSequence)"===========================================================");
        }
    }

    private boolean projectIsSubmodule(MavenProject project, Log log) {
        MavenProject parent = project.getParent();
        if (parent != null) {
            for (String module : parent.getOriginalModel().getModules()) {
                File parentProjectWithModule = new File(parent.getFile().getParentFile(), module);
                log.warn((CharSequence)("project Parent + sub: " + parentProjectWithModule));
                File projectParentFolder = project.getFile().getParentFile();
                log.warn((CharSequence)("project file" + projectParentFolder));
                if (!parentProjectWithModule.equals(projectParentFolder)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean ruleIsDefinedInProjectOrNotModuleParent(MavenProject project, Log log) {
        if (project == null) {
            return false;
        }
        log.warn((CharSequence)("<<< " + project.toString() + " >>>"));
        log.warn((CharSequence)("project Parent: " + project.getParent()));
        log.warn((CharSequence)("project orig Model Parent: " + project.getOriginalModel().getParent()));
        if (this.ruleDefinedInProject(project)) {
            return true;
        }
        if (!this.projectIsSubmodule(project, log)) {
            return this.ruleIsDefinedInProjectOrNotModuleParent(project.getParent(), log);
        }
        return false;
    }

    private boolean ruleDefinedInProject(MavenProject project) {
        Build build = project.getOriginalModel().getBuild();
        if (build != null) {
            Plugin plugin = (Plugin)build.getPluginsAsMap().get("org.apache.maven.plugins:maven-enforcer-plugin");
            for (PluginExecution execution : plugin.getExecutions()) {
                Xpp3Dom configuration = (Xpp3Dom)execution.getConfiguration();
                Xpp3Dom rules = configuration.getChild("rules");
                if (rules == null || rules.getChild(((Object)((Object)this)).getClass().getSimpleName()) == null) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean projectHasManagedDependencies(MavenProject project) {
        return project.getDependencyManagement() != null && project.getDependencyManagement().getDependencies().size() > 0;
    }
}

