/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.rules.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import java.util.List;
import net.oneandone.maven.rules.common.AbstractRule;
import net.oneandone.maven.rules.common.DifferenceHandler;
import net.oneandone.maven.rules.common.RuleHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public abstract class AbstractFilterableRule
extends AbstractRule {
    private List<String> excludes = null;

    protected boolean isExcluded(String artifactIdentifier) {
        if (this.excludes != null && this.excludes.size() > 0) {
            for (String exclude : this.excludes) {
                if (!artifactIdentifier.startsWith(exclude)) continue;
                return true;
            }
        }
        return false;
    }

    protected void compareDependenciesWithParentManagement(MavenProject project, Log log, DifferenceHandler differenceHandler) {
        if (project.getParent() != null) {
            List projectDependencies = project.getDependencies();
            if (project.getDependencyManagement() != null) {
                projectDependencies.addAll(project.getDependencyManagement().getDependencies());
            }
            ImmutableListMultimap<String, Dependency> parentProjectDependencies = RuleHelper.getManagedDependenciesAsMap(project.getParent());
            block0: for (Dependency dependency : projectDependencies) {
                ImmutableList parentDependencies = parentProjectDependencies.get((Object)RuleHelper.getDependencyIdentifier(dependency));
                if (parentDependencies == null || this.isExcluded(dependency.getManagementKey())) continue;
                for (Dependency parentDependency : parentDependencies) {
                    if (!dependency.getManagementKey().equals(parentDependency.getManagementKey())) continue;
                    if (dependency.getVersion().equals(parentDependency.getVersion())) continue block0;
                    differenceHandler.handleDifference(log, dependency, parentDependency);
                    continue block0;
                }
            }
        }
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }
}

