/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.rules;

import net.oneandone.maven.rules.common.AbstractFilterableRule;
import net.oneandone.maven.rules.common.DifferenceHandler;
import net.oneandone.maven.rules.common.RuleHelper;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public class ForbidOverridingManagedDependenciesRule
extends AbstractFilterableRule {
    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Log log = helper.getLog();
        try {
            MavenProject project = RuleHelper.getProject(helper);
            this.compareDependenciesWithParentManagement(project, log, new DifferenceHandler(){

                @Override
                public void handleDifference(Log log, Dependency dependency, Dependency parentDependency) {
                    ForbidOverridingManagedDependenciesRule.this.logHeader(log, "dependency management");
                    log.warn((CharSequence)("Difference for: " + dependency.getManagementKey()));
                    log.warn((CharSequence)("Project: " + dependency.getVersion()));
                    log.warn((CharSequence)("Parent:  " + parentDependency.getVersion()));
                    log.warn((CharSequence)"----------------------------------------");
                    ForbidOverridingManagedDependenciesRule.this.failureDetected = true;
                }
            });
            if (this.failureDetected) {
                throw new EnforcerRuleException("Failing because of overridden managed dependencies");
            }
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to lookup an expression " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }
}

