/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.rules.common;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public abstract class AbstractRule
extends AbstractNonCacheableEnforcerRule {
    protected boolean failureDetected = false;
    private String lastLogHeader = null;

    protected void logHeader(Log log, String type) {
        if (!Objects.equals(this.lastLogHeader, type)) {
            this.lastLogHeader = type;
            log.warn((CharSequence)(type + " findings of " + ((Object)((Object)this)).getClass().getSimpleName()));
            log.warn((CharSequence)"===========================================================");
        }
    }

    private boolean projectIsSubmodule(MavenProject project, Log log) {
        MavenProject parent = project.getParent();
        if (parent != null) {
            for (String module : parent.getOriginalModel().getModules()) {
                File parentProjectWithModule = new File(parent.getFile().getParentFile(), module);
                log.warn((CharSequence)("project Parent + sub: " + parentProjectWithModule));
                File projectParentFolder = project.getFile().getParentFile();
                log.warn((CharSequence)("project file" + projectParentFolder));
                if (!parentProjectWithModule.equals(projectParentFolder)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean ruleIsDefinedInProjectOrNotModuleParent(MavenProject project, Log log) {
        if (project == null) {
            return false;
        }
        log.debug((CharSequence)("<<< " + project.toString() + " >>>"));
        log.debug((CharSequence)("project Parent: " + project.getParent()));
        log.debug((CharSequence)("project orig Model Parent: " + project.getOriginalModel().getParent()));
        if (this.ruleDefinedInProject(project)) {
            return true;
        }
        if (!this.projectIsSubmodule(project, log)) {
            return this.ruleIsDefinedInProjectOrNotModuleParent(project.getParent(), log);
        }
        return false;
    }

    private boolean ruleDefinedInProject(MavenProject project) {
        for (BuildBase activeBuild : this.getDefinedActiveBuilds(project)) {
            Plugin plugin = (Plugin)activeBuild.getPluginsAsMap().get("org.apache.maven.plugins:maven-enforcer-plugin");
            if (plugin == null) continue;
            for (PluginExecution execution : plugin.getExecutions()) {
                if (!this.isRuleInConfiguration(execution, ((Object)((Object)this)).getClass().getSimpleName())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRuleInConfiguration(PluginExecution execution, String ruleName) {
        Xpp3Dom configuration = (Xpp3Dom)execution.getConfiguration();
        Xpp3Dom rules = configuration.getChild("rules");
        return rules != null && rules.getChild(ruleName) != null;
    }

    private Set<BuildBase> getDefinedActiveBuilds(MavenProject project) {
        HashSet<BuildBase> activeBuilds = new HashSet<BuildBase>();
        Model originalModel = project.getOriginalModel();
        Build build = originalModel.getBuild();
        activeBuilds.add((BuildBase)build);
        List originalProfiles = originalModel.getProfiles();
        if (originalProfiles != null) {
            for (Profile profile : project.getActiveProfiles()) {
                for (Profile originalProfile : originalProfiles) {
                    if (!originalProfile.equals(profile)) continue;
                    activeBuilds.add(originalProfile.getBuild());
                }
            }
        }
        activeBuilds.remove(null);
        return activeBuilds;
    }

    protected boolean projectHasManagedDependencies(MavenProject project) {
        return project.getDependencyManagement() != null && !project.getDependencyManagement().getDependencies().isEmpty();
    }
}

