/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.rules;

import com.google.common.collect.ImmutableListMultimap;
import java.util.List;
import net.oneandone.maven.rules.common.AbstractRule;
import net.oneandone.maven.rules.common.RuleHelper;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public class ManageAllModulesRule
extends AbstractRule {
    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            MavenProject project = RuleHelper.getProject(helper);
            if (this.ruleIsDefinedInProjectOrNotModuleParent(project, helper.getLog())) {
                this.detectUnmanagedModules(helper, project);
            }
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to lookup an expression " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    private void detectUnmanagedModules(EnforcerRuleHelper helper, MavenProject project) throws ExpressionEvaluationException, EnforcerRuleException {
        Log log = helper.getLog();
        MavenSession session = RuleHelper.getSession(helper);
        List projects = session.getProjects();
        ImmutableListMultimap<String, Dependency> managedDependencies = RuleHelper.getManagedDependenciesAsMap(project);
        for (MavenProject mavenProject : projects) {
            String projectIdentifier;
            if (this.ruleIsDefinedInProjectOrNotModuleParent(mavenProject, log) || managedDependencies.containsKey((Object)(projectIdentifier = RuleHelper.getProjectIdentifier(mavenProject)))) continue;
            this.logHeader(log, "manage all modules");
            log.warn((CharSequence)("unmanaged project found: " + projectIdentifier));
            this.failureDetected = true;
        }
        if (this.failureDetected) {
            throw new EnforcerRuleException("Failing because of unmanaged projects");
        }
    }
}

