/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.rules;

import java.util.List;
import java.util.Map;
import net.oneandone.maven.rules.common.AbstractFilterableRule;
import net.oneandone.maven.rules.common.RuleHelper;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public class ForbidOverridingManagedPluginsRule
extends AbstractFilterableRule {
    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Log log = helper.getLog();
        try {
            MavenProject project = RuleHelper.getProject(helper);
            this.checkPluginManagementDiffs(project, log);
            if (this.failureDetected) {
                throw new EnforcerRuleException("Failing because of overridden managed plugins");
            }
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to lookup an expression " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    private void checkPluginManagementDiffs(MavenProject project, Log log) {
        if (project.getParent() != null) {
            List projectPlugins = project.getBuildPlugins();
            if (project.getPluginManagement() != null) {
                projectPlugins.addAll(project.getPluginManagement().getPlugins());
            }
            Map parentProjectPlugins = project.getParent().getPluginManagement().getPluginsAsMap();
            for (Plugin plugin : projectPlugins) {
                Plugin parentPlugin = (Plugin)parentProjectPlugins.get(plugin.getKey());
                if (parentPlugin == null || plugin.getVersion().equals(parentPlugin.getVersion()) || this.isExcluded(plugin.getKey())) continue;
                this.logHeader(log, "plugin management");
                log.warn((CharSequence)("Difference for: " + plugin.getKey()));
                log.warn((CharSequence)("Project: " + plugin.getVersion()));
                log.warn((CharSequence)("Parent:  " + parentPlugin.getVersion()));
                log.warn((CharSequence)"----------------------------------------");
                this.failureDetected = true;
            }
        }
    }
}

