/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.maven.rules;

import net.oneandone.maven.rules.common.AbstractFilterableRule;
import net.oneandone.maven.rules.common.RuleHelper;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public class ForbidDependencyManagementInSubModulesRule
extends AbstractFilterableRule {
    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Log log = helper.getLog();
        try {
            MavenProject currentProject = RuleHelper.getSession(helper).getCurrentProject();
            this.checkForSubmoduleDependencyManagement(currentProject, log);
            if (this.failureDetected) {
                throw new EnforcerRuleException("Failing because of forbidden dependency management in sub modules");
            }
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to lookup an expression " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    private void checkForSubmoduleDependencyManagement(MavenProject project, Log log) {
        DependencyManagement dependencyManagement;
        if (this.projectHasManagedDependencies(project) && !project.isExecutionRoot() && !this.isExcluded(RuleHelper.getProjectIdentifier(project)) && (dependencyManagement = project.getOriginalModel().getDependencyManagement()).getDependencies().size() > 0) {
            this.failureDetected = true;
            this.logHeader(log, "dependency management in sub modules");
            for (Dependency dependency : dependencyManagement.getDependencies()) {
                log.warn((CharSequence)("module '" + project.getArtifact().getDependencyConflictId() + "' has dependency management for: " + dependency.getManagementKey()));
            }
        }
    }

    private boolean projectHasManagedDependencies(MavenProject project) {
        return project.getDependencyManagement() != null && project.getDependencyManagement().getDependencies().size() > 0;
    }
}

