/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.iocunit;

import com.oneandone.cdi.weldstarter.CreationalContexts;
import com.oneandone.cdi.weldstarter.spi.TestExtensionService;
import com.oneandone.iocunit.IocUnitAnalyzeAndStarter;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import org.junit.Test;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IocUnitRunner
extends BlockJUnit4ClassRunner {
    private static Logger logger = LoggerFactory.getLogger(IocUnitRunner.class);
    private final Class<?> clazz;
    private final List<TestExtensionService> testExtensionServices = new ArrayList<TestExtensionService>();
    private FrameworkMethod frameworkMethod;
    private Throwable startupException;
    IocUnitAnalyzeAndStarter analyzeAndStarter = new IocUnitAnalyzeAndStarter();

    public IocUnitRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
        this.clazz = clazz;
    }

    protected Statement methodBlock(final FrameworkMethod frameworkMethodP) {
        this.frameworkMethod = frameworkMethodP;
        final Statement defaultStatement = super.methodBlock(frameworkMethodP);
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                if (IocUnitRunner.this.startupException != null) {
                    if (((Test)frameworkMethodP.getAnnotation(Test.class)).expected() == IocUnitRunner.this.startupException.getClass()) {
                        return;
                    }
                    throw IocUnitRunner.this.startupException;
                }
                System.setProperty("java.naming.factory.initial", "com.oneandone.iocunit.naming.CdiTesterContextFactory");
                InitialContext initialContext = new InitialContext();
                BeanManager beanManager = IocUnitRunner.this.analyzeAndStarter.get(BeanManager.class);
                initialContext.rebind("java:comp/BeanManager", (Object)beanManager);
                try (CreationalContexts creationalContexts = new CreationalContexts(beanManager);){
                    defaultStatement.evaluate();
                }
                finally {
                    initialContext.close();
                    IocUnitRunner.this.analyzeAndStarter.tearDown();
                }
            }
        };
    }

    protected Object createTest() throws Exception {
        try {
            this.startupException = this.analyzeAndStarter.checkVersion();
            System.setProperty("java.naming.factory.initial", "com.oneandone.iocunit.naming.CdiTesterContextFactory");
            if (this.startupException == null) {
                try {
                    this.analyzeAndStarter.analyzeAndStart(this.clazz, this.frameworkMethod.getMethod());
                    this.analyzeAndStarter.initContexts();
                }
                catch (Throwable e) {
                    if (this.startupException == null) {
                        this.startupException = e;
                    }
                }
            }
        }
        catch (Throwable e) {
            this.startupException = new Exception("Unable to start weld", e);
        }
        return this.analyzeAndStarter.get(this.clazz);
    }
}

