/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.iocunit;

import com.oneandone.cdi.weldstarter.spi.TestExtensionService;
import com.oneandone.iocunit.IocUnitAnalyzeAndStarter;
import com.oneandone.iocunit.analyzer.InitialConfiguration;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IocUnitRule
implements TestRule {
    private static Logger logger = LoggerFactory.getLogger(IocUnitRule.class);
    private final Object instance;
    private final InitialConfiguration initialConfiguration;
    private final List<TestExtensionService> testExtensionServices = new ArrayList<TestExtensionService>();
    private Method method;
    IocUnitAnalyzeAndStarter analyzeAndStarter;

    public IocUnitRule(Object instance) {
        this(instance, new InitialConfiguration());
    }

    public IocUnitRule(Object instance, InitialConfiguration initialConfiguration) {
        this.instance = instance;
        this.initialConfiguration = initialConfiguration;
        this.analyzeAndStarter = new IocUnitAnalyzeAndStarter(initialConfiguration);
    }

    public Statement apply(Statement base, Description description) {
        try {
            this.method = description.getTestClass().getMethod(description.getMethodName(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        Deployment result = new Deployment(this.instance, base, this.method);
        if (result.startupException != null && !this.method.getAnnotation(Test.class).expected().equals(result.startupException.getClass())) {
            throw new RuntimeException(result.startupException);
        }
        return result;
    }

    public class Deployment
    extends Statement {
        private static final String ABSENT_CODE_PREFIX = "Absent Code attribute in method that is not native or abstract in class file ";
        private final Statement next;
        protected Throwable startupException;
        private Class<?> clazz;
        private Object testInstance;

        public Deployment(Object instance, Statement next, Method method) {
            block3: {
                this.clazz = instance.getClass();
                this.testInstance = instance;
                this.next = next;
                try {
                    this.startupException = IocUnitRule.this.analyzeAndStarter.checkVersion();
                    IocUnitRule.this.analyzeAndStarter.analyzeAndStart(this.clazz, method);
                }
                catch (ClassFormatError e) {
                    this.startupException = this.parseClassFormatError(e);
                }
                catch (Throwable e) {
                    if (this.startupException != null) break block3;
                    this.startupException = e;
                }
            }
        }

        private ClassFormatError parseClassFormatError(ClassFormatError e) {
            if (e.getMessage().startsWith(ABSENT_CODE_PREFIX)) {
                String offendingClass = e.getMessage().substring(ABSENT_CODE_PREFIX.length());
                URL url = IocUnitRule.class.getClassLoader().getResource(offendingClass + ".class");
                return new ClassFormatError("'" + offendingClass.replace('/', '.') + "' is an API only class. You need to remove '" + url.toString().substring(9, url.toString().indexOf("!")) + "' from your classpath");
            }
            return e;
        }

        public void evaluate() throws Throwable {
            if (IocUnitRule.this.analyzeAndStarter.weldSetup == null) {
                this.initWeld();
            }
            if (this.startupException != null) {
                if (IocUnitRule.this.method != null && IocUnitRule.this.method.getAnnotation(Test.class).expected() == this.startupException.getClass()) {
                    return;
                }
                throw this.startupException;
            }
            try {
                IocUnitRule.this.analyzeAndStarter.initContexts();
                Object test = IocUnitRule.this.analyzeAndStarter.getCreationalContexts().create(this.clazz, ApplicationScoped.class);
                this.initWeldFields(test, test.getClass());
                this.next.evaluate();
            }
            finally {
                IocUnitRule.this.analyzeAndStarter.tearDown();
            }
        }

        public void initWeld() {
            block4: {
                if (this.startupException == null) {
                    try {
                        IocUnitRule.this.analyzeAndStarter.getWeldStarter();
                    }
                    catch (Throwable e) {
                        if (this.startupException == null) {
                            this.startupException = e;
                        }
                        if (!(e instanceof ClassFormatError)) break block4;
                        throw e;
                    }
                }
            }
        }

        private void initWeldFields(Object newTestInstance, Class<?> clazzP) throws IllegalAccessException {
            if (clazzP.equals(Object.class)) {
                return;
            }
            for (Field f : clazzP.getDeclaredFields()) {
                f.setAccessible(true);
                if (f.getAnnotation(Inject.class) != null) {
                    f.set(this.testInstance, f.get(newTestInstance));
                    continue;
                }
                if (f.get(newTestInstance) == null || f.get(this.testInstance) != null) continue;
                f.set(this.testInstance, f.get(newTestInstance));
            }
            this.initWeldFields(newTestInstance, clazzP.getSuperclass());
        }
    }
}

