/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.iocunit;

import com.oneandone.cdi.weldstarter.CreationalContexts;
import com.oneandone.cdi.weldstarter.WeldSetup;
import com.oneandone.cdi.weldstarter.WeldSetupClass;
import com.oneandone.cdi.weldstarter.spi.TestExtensionService;
import com.oneandone.cdi.weldstarter.spi.WeldStarter;
import com.oneandone.iocunit.analyzer.ConfigCreator;
import com.oneandone.iocunit.analyzer.InitialConfiguration;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IocUnitAnalyzeAndStarter {
    private static Logger logger = LoggerFactory.getLogger(IocUnitAnalyzeAndStarter.class);
    private final InitialConfiguration initialConfiguration;
    private WeldStarter weldStarter = null;
    WeldSetupClass weldSetup;
    ConfigCreator cdiConfigCreator = null;
    private CreationalContexts creationalContexts;
    InitialContext initialContext;
    private final List<TestExtensionService> testExtensionServices = new ArrayList<TestExtensionService>();

    public WeldStarter getWeldStarter() {
        if (this.weldStarter == null) {
            this.weldStarter = WeldSetupClass.getWeldStarter();
        }
        return this.weldStarter;
    }

    public <T> T get(Class<T> clazz) {
        return (T)this.getWeldStarter().get(clazz, new Annotation[0]);
    }

    public boolean isRunning() {
        return this.weldStarter != null;
    }

    public IocUnitAnalyzeAndStarter(InitialConfiguration initialConfiguration) {
        this.initialConfiguration = initialConfiguration;
        if (this.testExtensionServices.size() == 0) {
            ServiceLoader<TestExtensionService> loader = ServiceLoader.load(TestExtensionService.class);
            Iterator<TestExtensionService> testExtensionServiceIterator = loader.iterator();
            while (testExtensionServiceIterator.hasNext()) {
                this.testExtensionServices.add(testExtensionServiceIterator.next());
            }
        }
    }

    public IocUnitAnalyzeAndStarter() {
        this(new InitialConfiguration());
    }

    public void analyzeAndStart(Class<?> clazz, Method testMethod) {
        if (this.cdiConfigCreator == null) {
            InitialConfiguration cfg = this.initialConfiguration;
            cfg.testClass = clazz;
            cfg.testMethod = testMethod;
            cfg.initialClasses.add(BeanManager.class);
            this.cdiConfigCreator = new ConfigCreator();
            this.cdiConfigCreator.create(cfg);
        }
        this.weldSetup = this.cdiConfigCreator.buildWeldSetup(testMethod);
        this.preStartupActions();
        this.getWeldStarter().start((WeldSetup)this.weldSetup);
    }

    public void preStartupActions() {
        if (this.testExtensionServices != null) {
            for (TestExtensionService te : this.testExtensionServices) {
                te.preStartupAction(this.weldSetup);
            }
        }
    }

    public void initContexts() throws Exception {
        System.setProperty("java.naming.factory.initial", "com.oneandone.iocunit.naming.CdiTesterContextFactory");
        this.initialContext = new InitialContext();
        BeanManager beanManager = this.get(BeanManager.class);
        this.initialContext.rebind("java:comp/BeanManager", (Object)beanManager);
        this.creationalContexts = new CreationalContexts(beanManager);
        this.postStartupActions();
    }

    public void shutdownWeldIfRunning(boolean ignoreException) throws NamingException {
        if (this.weldStarter != null) {
            logger.trace("----> shutting down Weld");
            if (ignoreException) {
                try {
                    if (this.creationalContexts != null) {
                        this.creationalContexts.close();
                        this.creationalContexts = null;
                    }
                    if (this.initialContext != null) {
                        this.initialContext.close();
                        this.initialContext = null;
                    }
                    this.weldStarter.tearDown();
                }
                catch (Throwable thw) {
                    logger.debug("Ignored {}", thw);
                }
            } else {
                this.weldStarter.tearDown();
            }
            this.weldStarter = null;
        }
    }

    public void postStartupActions() {
        if (this.testExtensionServices != null) {
            for (TestExtensionService te : this.testExtensionServices) {
                te.postStartupAction(this.creationalContexts, this.weldStarter);
            }
        }
    }

    public void tearDown() {
        this.getWeldStarter().tearDown();
        this.weldStarter = null;
    }

    public Throwable checkVersion() {
        String version = this.getWeldStarter().getVersion();
        if ("2.2.8 (Final)".equals(version) || "2.2.7 (Final)".equals(version)) {
            return new Exception("Weld 2.2.8 and 2.2.7 are not supported. Suggest upgrading to 2.2.9");
        }
        return null;
    }

    public <T> CreationalContexts getCreationalContexts() {
        return this.creationalContexts;
    }
}

