/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.iocunit;

import com.oneandone.iocunit.ExpectedStartupException;
import com.oneandone.iocunit.IocUnitAnalyzeAndStarter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import javax.enterprise.context.ApplicationScoped;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestInstanceFactory;
import org.junit.jupiter.api.extension.TestInstanceFactoryContext;
import org.junit.jupiter.api.extension.TestInstantiationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IocJUnit5Extension
implements BeforeEachCallback,
AfterAllCallback,
TestExecutionExceptionHandler,
TestInstanceFactory {
    private static Logger logger = LoggerFactory.getLogger(IocJUnit5Extension.class);
    private static final String ABSENT_CODE_PREFIX = "Absent Code attribute in method that is not native or abstract in class file ";
    IocUnitAnalyzeAndStarter analyzeAndStarter = new IocUnitAnalyzeAndStarter();
    protected Throwable startupException;
    private Method testMethod;
    private Class<?> testClass;

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        logger.trace("---->after All execution {} {}\n", (Object)extensionContext.getDisplayName(), (Object)this);
        this.analyzeAndStarter.shutdownWeldIfRunning(false);
    }

    private Object createTestInstance(Class<?> clazz) throws Exception {
        this.startupException = null;
        this.analyzeAndStarter.shutdownWeldIfRunning(false);
        if (!this.analyzeAndStarter.isRunning()) {
            block6: {
                logger.trace("----> starting up Weld.");
                this.startupException = this.analyzeAndStarter.checkVersion();
                System.setProperty("java.naming.factory.initial", "com.oneandone.iocunit.naming.CdiTesterContextFactory");
                try {
                    if (this.startupException == null) {
                        this.analyzeAndStarter.analyzeAndStart(clazz, null);
                    }
                }
                catch (ClassFormatError e) {
                    this.startupException = this.parseClassFormatError(e);
                }
                catch (Throwable e) {
                    if (this.startupException != null) break block6;
                    this.startupException = e;
                }
            }
            if (this.startupException != null) {
                return clazz.newInstance();
            }
            this.analyzeAndStarter.initContexts();
            Object test = this.analyzeAndStarter.getCreationalContexts().create(clazz, ApplicationScoped.class);
            logger.trace("---->Found testinstance {}\n", test);
            return test;
        }
        return null;
    }

    private ClassFormatError parseClassFormatError(ClassFormatError e) {
        if (e.getMessage().startsWith(ABSENT_CODE_PREFIX)) {
            String offendingClass = e.getMessage().substring(ABSENT_CODE_PREFIX.length());
            URL url = IocJUnit5Extension.class.getClassLoader().getResource(offendingClass + ".class");
            return new ClassFormatError("'" + offendingClass.replace('/', '.') + "' is an API only class. You need to remove '" + url.toString().substring(9, url.toString().indexOf("!")) + "' from your classpath");
        }
        return e;
    }

    public void handleTestExecutionException(ExtensionContext extensionContext, Throwable throwable) throws Throwable {
        if (this.startupException != null) {
            logger.info("\"{}\" Ignored because of StartupException \"{}\"", (Object)throwable, (Object)this.startupException.getMessage());
            return;
        }
        throw throwable;
    }

    public Object createTestInstance(TestInstanceFactoryContext testInstanceFactoryContext, ExtensionContext extensionContext) throws TestInstantiationException {
        try {
            logger.trace("---->createTestInstance {} {}", (Object)testInstanceFactoryContext.getTestClass(), (Object)testInstanceFactoryContext.getOuterInstance());
            if (!testInstanceFactoryContext.getOuterInstance().isPresent()) {
                Object test = this.createTestInstance(testInstanceFactoryContext.getTestClass());
                return test;
            }
            Object outerInstance = testInstanceFactoryContext.getOuterInstance().get();
            Constructor c = testInstanceFactoryContext.getTestClass().getDeclaredConstructor(outerInstance.getClass());
            c.setAccessible(true);
            return c.newInstance(outerInstance);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        if (this.startupException != null) {
            ExpectedStartupException ann;
            this.testMethod = extensionContext.getTestMethod().orElse(null);
            this.testClass = extensionContext.getTestClass().orElse(null);
            if (extensionContext.getTestMethod().isPresent() && ((Method)extensionContext.getTestMethod().get()).isAnnotationPresent(ExpectedStartupException.class) && (ann = ((Method)extensionContext.getTestMethod().get()).getAnnotation(ExpectedStartupException.class)).value().isAssignableFrom(this.startupException.getClass())) {
                this.analyzeAndStarter.shutdownWeldIfRunning(true);
                return;
            }
            if (this.startupException instanceof Exception) {
                throw (Exception)this.startupException;
            }
            throw new RuntimeException(this.startupException);
        }
    }
}

