/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.iocunit.jms.rabbitmq;

import com.melowe.jms2.compat.Jms2ConnectionFactory;
import com.melowe.jms2.compat.Jms2Message;
import com.melowe.jms2.compat.Jms2MessageListener;
import com.oneandone.iocunit.jms.JmsSingletonsIntf;
import com.rabbitmq.jms.admin.RMQConnectionFactory;
import com.rabbitmq.jms.admin.RMQDestination;
import io.arivera.oss.embedded.rabbitmq.EmbeddedRabbitMq;
import io.arivera.oss.embedded.rabbitmq.EmbeddedRabbitMqConfig;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PreDestroy;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Topic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RabbitMQSingletons
implements JmsSingletonsIntf {
    private AtomicReference<Jms2ConnectionFactory> connectionFactoryAtomicReference = new AtomicReference();
    private AtomicReference<Connection> mdbConnection = new AtomicReference();
    private Logger logger = LoggerFactory.getLogger((String)"JmsFactory");
    private AtomicReference<Map<String, Destination>> destinations = new AtomicReference();
    static EmbeddedRabbitMq rabbitMq;

    public Connection getConnection() {
        try {
            this.getConnectionFactory();
        }
        catch (Exception e) {
            if (rabbitMq == null) {
                EmbeddedRabbitMqConfig config = new EmbeddedRabbitMqConfig.Builder().rabbitMqServerInitializationTimeoutInMillis(10000L).build();
                rabbitMq = new EmbeddedRabbitMq(config);
                rabbitMq.start();
                try {
                    Connection connection = this.connectionFactoryAtomicReference.get().createConnection();
                    connection.start();
                    this.destinations.set(new ConcurrentHashMap());
                    this.mdbConnection.set(connection);
                }
                catch (Exception embedding) {
                    throw new RuntimeException(embedding);
                }
            }
            throw new RuntimeException(e);
        }
        return this.mdbConnection.get();
    }

    @Produces
    JMSContext createJMSContext() {
        try {
            this.getConnectionFactory();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.connectionFactoryAtomicReference.get().createContext();
    }

    @PreDestroy
    public void destroy() {
        try {
            this.mdbConnection.get().close();
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }

    public Queue createQueue(String name) {
        if (!this.destinations.get().containsKey(name)) {
            this.destinations.get().put(name, (Destination)new RMQDestination(name, true, true));
        }
        return (Queue)this.destinations.get().get(name);
    }

    public Topic createTopic(String name) {
        if (!this.destinations.get().containsKey(name)) {
            this.destinations.get().put(name, (Destination)new RMQDestination(name, false, true));
        }
        return (Topic)this.destinations.get().get(name);
    }

    public ConnectionFactory getConnectionFactory() throws Exception {
        if (this.connectionFactoryAtomicReference.get() == null) {
            RMQConnectionFactory cf = new RMQConnectionFactory();
            cf.setHost("localhost");
            cf.setUsername("guest");
            cf.setPassword("guest");
            cf.setVirtualHost("/");
            cf.setPort(5672);
            cf.setCleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose(true);
            Jms2ConnectionFactory jms2Cf = new Jms2ConnectionFactory((ConnectionFactory)cf);
            if (this.connectionFactoryAtomicReference.compareAndSet(null, jms2Cf)) {
                Connection connection = jms2Cf.createConnection();
                connection.start();
                this.destinations.set(new ConcurrentHashMap());
                this.mdbConnection.set(connection);
            }
        }
        return (ConnectionFactory)this.connectionFactoryAtomicReference.get();
    }

    public void jms2OnMessage(MessageListener listener, Message message) {
        if (message instanceof Jms2Message) {
            listener.onMessage(message);
        } else {
            new Jms2MessageListener(listener).onMessage(message);
        }
    }
}

