/*
 * Decompiled with CFR 0.152.
 */
package net.oijon.osca;

import java.util.ArrayList;

public class Category {
    String name;
    ArrayList<String> values;
    private static final String[] WHITESPACE_CHARS = new String[]{" ", "\t", "\n", "\r", "\f"};
    public static final Category WHITESPACE = new Category("#", WHITESPACE_CHARS);

    public Category(String name, ArrayList<String> values) {
        this.name = name;
        this.values = values;
    }

    public Category(String name, String[] values) {
        this.name = name;
        this.values = new ArrayList();
        for (int i = 0; i < values.length; ++i) {
            this.values.add(values[i]);
        }
    }

    public static ArrayList<String> generateMatchesFromCategoryList(ArrayList<Category> categories, String input) {
        boolean allFound = false;
        ArrayList<String> possibleTargets = new ArrayList<String>();
        possibleTargets.add(input);
        while (!allFound) {
            int i;
            boolean changedAnything = false;
            ArrayList<Integer> removeList = new ArrayList<Integer>();
            for (i = 0; i < possibleTargets.size(); ++i) {
                for (int j = 0; j < categories.size(); ++j) {
                    int index = possibleTargets.get(i).indexOf(categories.get((int)j).name);
                    if (index == -1) continue;
                    changedAnything = true;
                    removeList.add(i);
                    ArrayList<Object> categoryReplacements = new ArrayList();
                    categoryReplacements = categories.get(j).generatePossibleMatches(possibleTargets.get(i));
                    for (int k = 0; k < categoryReplacements.size(); ++k) {
                        possibleTargets.add((String)categoryReplacements.get(k));
                    }
                }
            }
            for (i = 0; i < removeList.size(); ++i) {
                possibleTargets.remove((Integer)removeList.get(i));
            }
            if (changedAnything) continue;
            allFound = true;
        }
        return possibleTargets;
    }

    public ArrayList<String> generatePossibleMatches(ArrayList<String> inputList) {
        ArrayList<String> output = new ArrayList<String>();
        for (int i = 0; i < inputList.size(); ++i) {
            ArrayList<String> intermediate = this.generatePossibleMatches(inputList.get(i));
            for (int j = 0; j < intermediate.size(); ++j) {
                output.add(intermediate.get(j));
            }
        }
        return output;
    }

    public ArrayList<String> replaceFirstInstance(String input) {
        ArrayList<String> output = new ArrayList<String>();
        for (int i = 0; i < this.values.size(); ++i) {
            String newString = input.replaceFirst(this.name, this.values.get(i));
            output.add(newString);
        }
        return output;
    }

    public String replaceInstance(String input, int instance, int indexInCat) {
        Object output = "";
        int numFound = 0;
        for (int i = 0; i < input.length(); ++i) {
            String prefix = input.substring(0, i);
            String substring = input.substring(i);
            if (substring.startsWith(this.name)) {
                ++numFound;
            }
            if (numFound != instance) continue;
            String newSubstring = substring.replaceFirst(substring, this.values.get(indexInCat));
            output = prefix + newSubstring;
            break;
        }
        return output;
    }

    public ArrayList<String> replaceInstance(String input, int instance) {
        ArrayList<String> output = new ArrayList<String>();
        int numFound = 0;
        for (int i = 0; i < input.length(); ++i) {
            String prefix = input.substring(0, i);
            String substring = input.substring(i);
            if (substring.startsWith(this.name)) {
                ++numFound;
            }
            if (numFound != instance) continue;
            for (int j = 0; j < this.values.size(); ++j) {
                String newSubstring = substring.replaceFirst(substring, this.values.get(j));
                String newString = prefix + newSubstring;
                output.add(newString);
            }
            break;
        }
        return output;
    }

    public ArrayList<String> generatePossibleMatches(String input) {
        ArrayList<String> output = new ArrayList<String>();
        if (input.contains(this.name)) {
            int i;
            int numTimes = 0;
            int lastFoundIndex = 0;
            boolean foundAll = false;
            while (!foundAll) {
                int index = input.indexOf(this.name, lastFoundIndex);
                if (index == -1) {
                    foundAll = true;
                    continue;
                }
                ++numTimes;
                lastFoundIndex = index + 1;
            }
            int[] indexArr = new int[numTimes];
            for (i = 0; i < indexArr.length; ++i) {
                indexArr[i] = 0;
            }
            i = 0;
            while ((double)i < Math.pow(this.values.size(), numTimes)) {
                int j;
                String possibility = input;
                for (j = 0; j < numTimes; ++j) {
                    possibility = possibility.replaceFirst(this.name, this.values.get(indexArr[j]));
                }
                output.add(possibility);
                indexArr[0] = indexArr[0] + 1;
                for (j = 0; j < numTimes - 1; ++j) {
                    if (indexArr[j] % this.values.size() != 0) continue;
                    indexArr[j] = 0;
                    indexArr[j + 1] = indexArr[j + 1] + 1;
                }
                ++i;
            }
        } else {
            output.add(input);
        }
        return output;
    }
}

