/*
 * Decompiled with CFR 0.152.
 */
package net.oijon.osca;

import java.util.ArrayList;
import java.util.regex.Pattern;
import net.oijon.olog.Log;
import net.oijon.osca.Category;
import net.oijon.osca.exception.InvalidRuleSyntaxException;

public class Rule {
    static Log log = new Log(System.getProperty("user.home") + "/.osca");
    protected static char[] whitespaces = new char[]{' ', '\t', '\n', '\r', '\f'};
    String target = "";
    String replacement = "";
    String environment = "";
    String exception = "";
    ArrayList<Category> categories = new ArrayList();
    ArrayList<String[]> mappings = new ArrayList();
    ArrayList<String> exceptions = new ArrayList();

    public Rule(String ruleStr) throws InvalidRuleSyntaxException {
        this.parseInputString(ruleStr);
        this.parseNonceCategories();
        this.generateMappings();
        this.parseOptionals();
    }

    public Rule(String ruleStr, ArrayList<Category> categories) throws InvalidRuleSyntaxException {
        this.parseInputString(ruleStr);
        this.categories = categories;
        this.parseNonceCategories();
        this.generateMappings();
        this.parseOptionals();
    }

    public Rule(String target, String replacement, String environment, ArrayList<Category> categories) {
        this.target = target;
        this.replacement = replacement;
        this.environment = environment;
        this.categories = categories;
        this.parseNonceCategories();
        this.generateMappings();
        this.parseOptionals();
    }

    public Rule(String target, String replacement, String environment) {
        this.target = target;
        this.replacement = replacement;
        this.environment = environment;
        this.parseNonceCategories();
        this.generateMappings();
        this.parseOptionals();
    }

    public Rule(String target, String replacement, String environment, String exception) {
        this.target = target;
        this.replacement = replacement;
        this.environment = environment;
        this.exception = exception;
        this.parseNonceCategories();
        this.generateMappings();
        this.parseOptionals();
    }

    public Rule(String target, String replacement, String environment, String exception, ArrayList<Category> categories) {
        this.target = target;
        this.replacement = replacement;
        this.environment = environment;
        this.exception = exception;
        this.categories = categories;
        this.parseNonceCategories();
        this.generateMappings();
        this.parseOptionals();
    }

    private void parseInputString(String ruleStr) throws InvalidRuleSyntaxException {
        String[] split = ruleStr.split("/");
        if (split.length < 3) {
            throw new InvalidRuleSyntaxException("Expected 3-4 parameters, got " + split.length);
        }
        this.target = split[0];
        this.replacement = split[1];
        this.environment = split[2];
        if (split.length >= 4) {
            this.exception = split[3];
        }
    }

    private int countCategories(String input) {
        int count = 0;
        for (int i = 0; i < this.categories.size(); ++i) {
            boolean foundAll = false;
            int lastIndex = 0;
            while (!foundAll) {
                int index = input.indexOf(this.categories.get((int)i).name, lastIndex);
                if (index == -1) {
                    foundAll = true;
                    continue;
                }
                ++count;
                lastIndex = index + 1;
            }
        }
        return count;
    }

    private Category[] getCategoriesFromString(String input) {
        int numCats = this.countCategories(input);
        Category[] categoryIndicies = new Category[numCats];
        this.categories.sort((a, b) -> -1 * this.compareStringsBySize(a.name, b.name));
        int numFound = 0;
        for (int i = 0; i < input.length(); ++i) {
            String substring = input.substring(i);
            for (int j = 0; j < this.categories.size(); ++j) {
                if (!substring.startsWith(this.categories.get((int)j).name)) continue;
                categoryIndicies[numFound] = this.categories.get(j);
                ++numFound;
            }
        }
        return categoryIndicies;
    }

    private void parseOptionals() {
        ArrayList<String> targets = this.parseOptionalsFromString(this.target);
        ArrayList<String> replacements = this.parseOptionalsFromString(this.replacement);
        ArrayList<String> environments = this.parseOptionalsFromString(this.environment);
        ArrayList<String> exceptions = this.parseOptionalsFromString(this.exception);
        for (int i = 0; i < targets.size(); ++i) {
            for (int j = 0; j < replacements.size(); ++j) {
                for (int k = 0; k < environments.size(); ++k) {
                    for (int l = 0; l < exceptions.size(); ++l) {
                        if (targets.get(i).equals(this.target) & replacements.get(j).equals(this.replacement) & environments.get(k).equals(this.environment) & exceptions.get(l).equals(this.exception)) continue;
                        Rule r = new Rule(targets.get(i), replacements.get(j), environments.get(k), exceptions.get(l), this.categories);
                        for (int m = 0; m < r.mappings.size(); ++m) {
                            this.mappings.add(r.mappings.get(m));
                        }
                    }
                }
            }
        }
    }

    private ArrayList<String> parseOptionalsFromString(String input) {
        ArrayList<String> output = new ArrayList<String>();
        output.add(input);
        boolean done = false;
        while (!done) {
            boolean anyChanges = false;
            for (int i = 0; i < output.size(); ++i) {
                int endIndex;
                String oldString = output.get(i);
                int beginIndex = oldString.indexOf(40);
                if (beginIndex == -1 || (endIndex = oldString.indexOf(41, beginIndex - 1)) == -1) continue;
                anyChanges = true;
                String parenthesizedString = oldString.substring(beginIndex, endIndex + 1);
                String newString = oldString.substring(0, beginIndex) + parenthesizedString.substring(1, parenthesizedString.length() - 1) + oldString.substring(endIndex + 1, oldString.length());
                oldString = oldString.replaceFirst(Pattern.quote(parenthesizedString), "");
                output.set(i, oldString);
                output.add(newString);
            }
            if (anyChanges) continue;
            done = true;
        }
        return output;
    }

    private void generateMappings() {
        int i;
        ArrayList<String> possibleTargets;
        this.mappings.clear();
        this.categories.add(Category.WHITESPACE);
        ArrayList<String[]> targetReplacementPairs = new ArrayList<String[]>();
        ArrayList<Object> allEnvs = new ArrayList<String>();
        ArrayList<Object> allExps = new ArrayList<String>();
        if (this.replacement.equals("\\\\\\\\")) {
            possibleTargets = Category.generateMatchesFromCategoryList(this.categories, this.target);
            for (int i2 = 0; i2 < possibleTargets.size(); ++i2) {
                String reverse = possibleTargets.get(i2);
                StringBuilder reverser = new StringBuilder();
                reverser.append(reverse);
                reverser.reverse();
                String[] newPair = new String[]{possibleTargets.get(i2), reverser.toString()};
                targetReplacementPairs.add(newPair);
            }
        } else if (this.countCategories(this.target) == 0) {
            String[] newPair = new String[]{this.target, this.replacement};
            targetReplacementPairs.add(newPair);
        } else if (this.countCategories(this.replacement) == 0) {
            possibleTargets = Category.generateMatchesFromCategoryList(this.categories, this.target);
            for (int i3 = 0; i3 < possibleTargets.size(); ++i3) {
                String[] newPair = new String[]{possibleTargets.get(i3), this.replacement};
                targetReplacementPairs.add(newPair);
            }
        } else {
            String[] barePair = new String[]{this.target, this.replacement};
            targetReplacementPairs.add(barePair);
            Category[] targetCategories = this.getCategoriesFromString(this.target);
            Category[] replacementCategories = this.getCategoriesFromString(this.replacement);
            int loopNum = targetCategories.length < replacementCategories.length ? targetCategories.length : replacementCategories.length;
            for (int i4 = 0; i4 < loopNum; ++i4) {
                int j;
                Category targetCat = targetCategories[i4];
                Category replacementCat = replacementCategories[i4];
                ArrayList<String[]> newMappings = new ArrayList<String[]>();
                ArrayList<String[]> removalList = new ArrayList<String[]>();
                for (j = 0; j < targetReplacementPairs.size(); ++j) {
                    boolean changedAnything = false;
                    for (int k = 0; k < targetCat.values.size(); ++k) {
                        int replacementIndex = k % replacementCat.values.size();
                        String oldTarget = ((String[])targetReplacementPairs.get(i4))[0];
                        String oldReplacement = ((String[])targetReplacementPairs.get(i4))[1];
                        String newTarget = oldTarget.replaceFirst(targetCat.name, targetCat.values.get(k));
                        String newReplacement = oldReplacement.replaceFirst(replacementCat.name, replacementCat.values.get(replacementIndex));
                        if (!newTarget.equals(oldTarget) | !newReplacement.equals(oldReplacement)) {
                            changedAnything = true;
                        }
                        String[] newPair = new String[]{newTarget, newReplacement};
                        newMappings.add(newPair);
                    }
                    if (!changedAnything) continue;
                    removalList.add((String[])targetReplacementPairs.get(j));
                }
                for (j = 0; j < newMappings.size(); ++j) {
                    targetReplacementPairs.add((String[])newMappings.get(j));
                }
            }
        }
        if (this.environment.equals("\u00b2")) {
            this.environment = "_\u00b2";
        }
        if (this.countCategories(this.environment) == 0) {
            allEnvs.add(this.environment);
        } else {
            allEnvs = Category.generateMatchesFromCategoryList(this.categories, this.environment);
        }
        if (this.countCategories(this.exception) == 0) {
            allExps.add(this.exception);
        } else {
            allExps = Category.generateMatchesFromCategoryList(this.categories, this.exception);
        }
        for (i = 0; i < allExps.size(); ++i) {
            for (int j = 0; j < targetReplacementPairs.size(); ++j) {
                String newExp = ((String)allExps.get(i)).replace("_", ((String[])targetReplacementPairs.get(j))[0]);
                this.exceptions.add(newExp);
            }
        }
        for (i = 0; i < targetReplacementPairs.size(); ++i) {
            for (int j = 0; j < allEnvs.size(); ++j) {
                String targetWithEnv = ((String)allEnvs.get(j)).replace("_", ((String[])targetReplacementPairs.get(i))[0]);
                targetWithEnv = targetWithEnv.replace("\u00b2", ((String[])targetReplacementPairs.get(i))[0]);
                String replacementWithEnv = ((String)allEnvs.get(j)).replace("_", ((String[])targetReplacementPairs.get(i))[1]);
                replacementWithEnv = replacementWithEnv.replace("\u00b2", ((String[])targetReplacementPairs.get(i))[0]);
                String[] newMapping = new String[]{targetWithEnv, replacementWithEnv};
                this.mappings.add(newMapping);
            }
        }
    }

    private int compareStringsBySize(String a, String b) {
        if (a.length() < b.length()) {
            return -1;
        }
        if (a.length() == b.length()) {
            return 0;
        }
        return 1;
    }

    private void parseNonceCategories() {
        this.target = this.parseNonceFromString(this.target);
        this.replacement = this.parseNonceFromString(this.replacement);
        this.environment = this.parseNonceFromString(this.environment);
        this.exception = this.parseNonceFromString(this.exception);
    }

    private String parseNonceFromString(String input) {
        String output = input;
        boolean done = false;
        while (!done) {
            int beginIndex = output.indexOf(91);
            if (beginIndex != -1) {
                int endIndex = output.indexOf(93, beginIndex - 1);
                if (endIndex != -1) {
                    String newCategoryString = output.substring(beginIndex, endIndex + 1);
                    boolean named = false;
                    Object categoryName = "";
                    int endInt = this.categories.size();
                    block1: while (!named) {
                        categoryName = "NONCECATEGORY" + endInt;
                        named = true;
                        for (int i = 0; i < this.categories.size(); ++i) {
                            if (!this.categories.get((int)i).name.equals(categoryName)) continue;
                            ++endInt;
                            named = false;
                            continue block1;
                        }
                    }
                    String[] catData = new String[newCategoryString.length() - 2];
                    for (int i = 1; i < newCategoryString.length() - 1; ++i) {
                        catData[i - 1] = Character.toString(newCategoryString.charAt(i));
                    }
                    Category newCategory = new Category((String)categoryName, catData);
                    this.categories.add(newCategory);
                    this.categories.sort((a, b) -> -1 * this.compareStringsBySize(a.name, b.name));
                    output = output.replace(newCategoryString, (CharSequence)categoryName);
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        }
        return output;
    }

    public String parse(String input) {
        boolean foundAll;
        int i;
        Object output = " " + input + " ";
        String suffix = "";
        int firstGlossChar = ((String)output).indexOf(8227);
        if (firstGlossChar != -1) {
            suffix = ((String)output).substring(firstGlossChar);
            output = ((String)output).substring(0, firstGlossChar - 1) + " ";
        }
        ArrayList<String[]> newValues = new ArrayList<String[]>();
        ArrayList<String[]> expValues = new ArrayList<String[]>();
        int numExpFound = 0;
        for (i = 0; i < this.exceptions.size(); ++i) {
            foundAll = false;
            if (this.exceptions.get(i).equals("")) {
                foundAll = true;
            }
            int lastIndex = 0;
            while (!foundAll) {
                int index = ((String)output).indexOf(this.exceptions.get(i), lastIndex);
                if (index > -1) {
                    String expPlaceholder = "\u2023\u2023E" + numExpFound + "\u2023\u2023";
                    ++numExpFound;
                    lastIndex = index + expPlaceholder.length();
                    output = ((String)output).replaceFirst(this.exceptions.get(i), expPlaceholder);
                    String[] pair = new String[]{expPlaceholder, this.exceptions.get(i)};
                    expValues.add(pair);
                    continue;
                }
                foundAll = true;
            }
        }
        for (i = 0; i < this.mappings.size(); ++i) {
            foundAll = false;
            while (!foundAll) {
                int index;
                String placeholder = "\u2023" + newValues.size() + "\u2023";
                String ourTarget = this.mappings.get(i)[0];
                String ourReplacement = this.mappings.get(i)[1];
                while (ourTarget.charAt(0) == '\u2026') {
                    ourTarget = ourTarget.substring(1);
                }
                while (ourTarget.charAt(ourTarget.length() - 1) == '\u2026') {
                    ourTarget = ourTarget.substring(0, ourTarget.length() - 1);
                }
                if (ourTarget.contains("\u2026")) {
                    String[] splitTarget = ourTarget.split("\u2026");
                    if (splitTarget.length > 1) {
                        for (int j = 0; j < splitTarget.length - 1; ++j) {
                            int endIndex;
                            int startIndex = ((String)output).indexOf(splitTarget[j]);
                            if (!(startIndex > 0 & (endIndex = ((String)output).indexOf(splitTarget[j + 1])) > 0 & startIndex < endIndex)) continue;
                            String inBetween = ((String)output).substring(startIndex += splitTarget[j].length(), endIndex);
                            ourTarget = ourTarget.replaceFirst(splitTarget[j] + "\u2026" + splitTarget[j + 1], splitTarget[j] + inBetween + splitTarget[j + 1]);
                            ourReplacement = ourReplacement.replaceFirst("\u2026", inBetween);
                        }
                    } else {
                        ourTarget = splitTarget[0];
                    }
                }
                if ((index = ((String)output).indexOf(ourTarget)) == -1) {
                    foundAll = true;
                    continue;
                }
                output = ((String)output).replace(ourTarget, placeholder);
                String[] pair = new String[]{placeholder, ourReplacement};
                newValues.add(pair);
            }
        }
        for (i = 0; i < newValues.size(); ++i) {
            output = ((String)output).replace(((String[])newValues.get(i))[0], ((String[])newValues.get(i))[1]);
        }
        for (i = 0; i < expValues.size(); ++i) {
            output = ((String)output).replace(((String[])expValues.get(i))[0], ((String[])expValues.get(i))[1]);
        }
        output = (String)output + suffix;
        output = ((String)output).substring(1);
        output = ((String)output).substring(0, ((String)output).length() - 1);
        return output;
    }

    public static String parseList(ArrayList<Rule> list, String input) {
        String output = input;
        for (int i = 0; i < list.size(); ++i) {
            output = list.get(i).parse(output);
        }
        return output;
    }

    public static ArrayList<Rule> parseFromList(String ruleList) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        String[] split = ruleList.split("\n");
        for (int i = 0; i < split.length; ++i) {
            try {
                Rule r = new Rule(split[i]);
                rules.add(r);
                continue;
            }
            catch (InvalidRuleSyntaxException e) {
                log.warn("On line \u2116" + i + " (" + split[i] + "): " + e.toString());
                e.printStackTrace();
            }
        }
        return rules;
    }

    public String toString() {
        String str = this.target + "/" + this.replacement + "/" + this.environment;
        if (!this.exception.equals("")) {
            str = str + "/" + this.exception;
        }
        return str;
    }
}

