/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.demo.record;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import net.officefloor.demo.macro.Macro;
import net.officefloor.demo.macro.MacroSource;
import net.officefloor.demo.macro.MacroSourceContext;
import net.officefloor.demo.macro.MacroTask;
import net.officefloor.demo.macro.MacroTaskContext;
import net.officefloor.demo.play.MacroPlayer;
import net.officefloor.demo.record.FrameVisibilityListener;
import net.officefloor.demo.record.RecordListener;

public class RecordComponent
extends JComponent {
    private final Toolkit toolKit = Toolkit.getDefaultToolkit();
    private final Frame frame;
    private final FrameVisibilityListener visibilityListener;
    private final JPopupMenu popupMenu = new JPopupMenu();
    private final RecordListener recordListener;
    private final Robot robot;
    private Image backgroundImage;
    private Point mouseLocationForNewMacro;
    private final Object anotherLocationLock = new Object();
    private Point anotherLocation = null;

    public RecordComponent(Robot robot, Frame frame, FrameVisibilityListener visibilityListener, RecordListener recordListener) throws AWTException {
        this.frame = frame;
        this.visibilityListener = visibilityListener;
        this.recordListener = recordListener;
        this.robot = robot;
        this.updateBackgroundImage();
        this.frame.addComponentListener(new RecordComponentListener());
        this.frame.addWindowFocusListener(new RecordWindowFocusListener());
        this.addMouseListener(new RecordMouseListener());
        this.popupMenu.add(new MacroAction(new RefreshDisplayMacroFactory(), false));
    }

    public Rectangle getRecordingArea() {
        Point location = this.getLocationOnScreen();
        Dimension size = this.getSize();
        return new Rectangle(location, size);
    }

    public JMenuItem addMacro(MacroSource macroFactory) {
        return this.popupMenu.add(new MacroAction(macroFactory, true));
    }

    public Macro getHideFrameMacro() {
        return new HideFrameMacro();
    }

    public Macro getShowFrameMacro() {
        Point frameLocation = this.frame.getLocation();
        return new ShowFrameMacro(frameLocation);
    }

    public Point getRelativeLocation(Point absoluteLocation) {
        Point offset = this.getLocationOnScreen();
        return new Point(absoluteLocation.x - offset.x, absoluteLocation.y - offset.y);
    }

    private void updateBackgroundImage() {
        try {
            Dimension dim = this.toolKit.getScreenSize();
            this.backgroundImage = this.robot.createScreenCapture(new Rectangle(0, 0, (int)dim.getWidth(), (int)dim.getHeight()));
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.frame, ex.getClass().getSimpleName() + ": " + ex.getMessage(), "Transparency Error", 0);
        }
    }

    private void refreshBackground() {
        if (this.isVisible()) {
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Point pos = this.getLocationOnScreen();
        Point offset = new Point(-pos.x, -pos.y);
        g.drawImage(this.backgroundImage, offset.x, offset.y, null);
    }

    private class RecordWindowFocusListener
    implements WindowFocusListener {
        private RecordWindowFocusListener() {
        }

        @Override
        public void windowGainedFocus(WindowEvent evt) {
            RecordComponent.this.refreshBackground();
        }

        @Override
        public void windowLostFocus(WindowEvent evt) {
            RecordComponent.this.refreshBackground();
        }
    }

    private class RecordComponentListener
    implements ComponentListener {
        private RecordComponentListener() {
        }

        @Override
        public void componentShown(ComponentEvent evt) {
            RecordComponent.this.repaint();
        }

        @Override
        public void componentResized(ComponentEvent evt) {
            RecordComponent.this.repaint();
        }

        @Override
        public void componentMoved(ComponentEvent evt) {
            RecordComponent.this.repaint();
        }

        @Override
        public void componentHidden(ComponentEvent evt) {
        }
    }

    private class RecordMouseListener
    extends MouseAdapter {
        private RecordMouseListener() {
        }

        private void showPopupMenu(MouseEvent e) {
            if (e.isPopupTrigger()) {
                Point componentOffset = e.getComponent().getLocationOnScreen();
                RecordComponent.this.mouseLocationForNewMacro = new Point(componentOffset.x + e.getX(), componentOffset.y + e.getY());
                RecordComponent.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                Object object = RecordComponent.this.anotherLocationLock;
                synchronized (object) {
                    Point eventLocation = e.getLocationOnScreen();
                    RecordComponent.this.anotherLocation = RecordComponent.this.getRelativeLocation(eventLocation);
                    RecordComponent.this.anotherLocationLock.notify();
                }
            }
            this.showPopupMenu(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.showPopupMenu(e);
        }
    }

    private class RefreshDisplayMacroFactory
    implements MacroSource,
    Macro,
    MacroTask {
        private RefreshDisplayMacroFactory() {
        }

        @Override
        public String getDisplayName() {
            return "Refresh display";
        }

        @Override
        public void sourceMacro(MacroSourceContext context) {
            context.setNewMacro(this);
        }

        @Override
        public void setConfigurationMemento(String memento) {
        }

        @Override
        public String getConfigurationMemento() {
            return "";
        }

        @Override
        public String getDisplayLabel() {
            throw new IllegalStateException("Should not be requiring display label");
        }

        @Override
        public Point getStartingMouseLocation() {
            return null;
        }

        @Override
        public MacroTask[] getMacroTasks() {
            return new MacroTask[]{this};
        }

        @Override
        public void runMacroTask(MacroTaskContext context) {
        }

        @Override
        public long getPostRunWaitTime() {
            return 500L;
        }
    }

    private class ShowFrameMacro
    implements Macro,
    MacroTask {
        private final Point frameLocation;

        public ShowFrameMacro(Point frameLocation) {
            this.frameLocation = frameLocation;
        }

        @Override
        public String getConfigurationMemento() {
            throw new IllegalStateException("Should not be storing");
        }

        @Override
        public void setConfigurationMemento(String memento) {
            throw new IllegalStateException("Should not be initiating");
        }

        @Override
        public String getDisplayLabel() {
            throw new IllegalStateException("Should not be requiring display label");
        }

        @Override
        public Point getStartingMouseLocation() {
            return null;
        }

        @Override
        public MacroTask[] getMacroTasks() {
            return new MacroTask[]{this};
        }

        @Override
        public void runMacroTask(MacroTaskContext context) {
            RecordComponent.this.updateBackgroundImage();
            RecordComponent.this.frame.setVisible(true);
            if (RecordComponent.this.visibilityListener != null) {
                RecordComponent.this.visibilityListener.notifyFrameVisibility(true);
            }
            RecordComponent.this.frame.setLocation(this.frameLocation);
            RecordComponent.this.refreshBackground();
        }

        @Override
        public long getPostRunWaitTime() {
            return 0L;
        }
    }

    private class HideFrameMacro
    implements Macro,
    MacroTask {
        private HideFrameMacro() {
        }

        @Override
        public String getConfigurationMemento() {
            throw new IllegalStateException("Should not be storing");
        }

        @Override
        public void setConfigurationMemento(String memento) {
            throw new IllegalStateException("Should not be initiating");
        }

        @Override
        public String getDisplayLabel() {
            throw new IllegalStateException("Should not be requiring display label");
        }

        @Override
        public Point getStartingMouseLocation() {
            return null;
        }

        @Override
        public MacroTask[] getMacroTasks() {
            return new MacroTask[]{this};
        }

        @Override
        public void runMacroTask(MacroTaskContext context) {
            RecordComponent.this.frame.setVisible(false);
            if (RecordComponent.this.visibilityListener != null) {
                RecordComponent.this.visibilityListener.notifyFrameVisibility(false);
            }
        }

        @Override
        public long getPostRunWaitTime() {
            return 0L;
        }
    }

    private class MacroAction
    extends AbstractAction
    implements MacroTaskContext,
    MacroSourceContext {
        private final MacroSource macroFactory;
        private final boolean isRecord;
        private Point referencePoint;

        public MacroAction(MacroSource macroFactory, boolean isRecord) {
            super(macroFactory.getDisplayName());
            this.referencePoint = null;
            this.macroFactory = macroFactory;
            this.isRecord = isRecord;
        }

        private Point getReferencePoint() {
            if (RecordComponent.this.frame.isVisible()) {
                this.referencePoint = RecordComponent.this.getLocationOnScreen();
            }
            return this.referencePoint;
        }

        private MacroPlayer getMacroPlayer() {
            Point offset = this.getReferencePoint();
            return new MacroPlayer(RecordComponent.this.robot, offset);
        }

        @Override
        public synchronized void actionPerformed(ActionEvent e) {
            try {
                this.getReferencePoint();
                this.macroFactory.sourceMacro(this);
            }
            catch (Throwable ex) {
                System.err.println("Failed to add macro");
                ex.printStackTrace();
            }
        }

        @Override
        public synchronized void setNewMacro(Macro macro) {
            Point referencePoint = this.getReferencePoint();
            new MacroPlayer(RecordComponent.this.robot, referencePoint).play(RecordComponent.this.getHideFrameMacro(), macro, RecordComponent.this.getShowFrameMacro());
            if (this.isRecord) {
                RecordComponent.this.recordListener.addMacro(macro);
            }
        }

        @Override
        public Point getLocation() {
            return this.getRelativeLocation(RecordComponent.this.mouseLocationForNewMacro);
        }

        @Override
        public Point getAnotherLocation() {
            Object object = RecordComponent.this.anotherLocationLock;
            synchronized (object) {
                RecordComponent.this.anotherLocation = null;
                long startTime = System.currentTimeMillis();
                while (true) {
                    if (RecordComponent.this.anotherLocation != null) {
                        return RecordComponent.this.anotherLocation;
                    }
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - startTime > 60000L) {
                        throw new Error("Waited too long for another location");
                    }
                    try {
                        RecordComponent.this.anotherLocationLock.wait(1000L);
                    }
                    catch (InterruptedException ex) {}
                }
            }
        }

        @Override
        public Point getAbsoluteLocation(Point relativeLocation) {
            Point offset = this.getReferencePoint();
            return new Point(offset.x + relativeLocation.x, offset.y + relativeLocation.y);
        }

        @Override
        public Point getRelativeLocation(Point absoluteLocation) {
            Point offset = this.getReferencePoint();
            return new Point(absoluteLocation.x - offset.x, absoluteLocation.y - offset.y);
        }

        @Override
        public Frame getOwnerFrame() {
            return RecordComponent.this.frame;
        }

        @Override
        public void mouseMove(int x, int y) {
            this.getMacroPlayer().mouseMove(x, y);
        }

        @Override
        public void mousePress(int buttons) {
            this.getMacroPlayer().mousePress(buttons);
        }

        @Override
        public void mouseRelease(int buttons) {
            this.getMacroPlayer().mouseRelease(buttons);
        }

        @Override
        public void mouseClick(int buttons) {
            this.mousePress(buttons);
            this.mouseRelease(buttons);
        }

        @Override
        public void mouseWheel(int wheelAmt) {
            this.getMacroPlayer().mouseWheel(wheelAmt);
        }

        @Override
        public void keyPress(int keycode) {
            this.getMacroPlayer().keyPress(keycode);
        }

        @Override
        public void keyRelease(int keycode) {
            this.getMacroPlayer().keyRelease(keycode);
        }

        @Override
        public void keyStroke(int keycode) {
            this.keyPress(keycode);
            this.keyRelease(keycode);
        }

        @Override
        public void keyText(String text) {
            this.getMacroPlayer().keyText(text);
        }
    }
}

