/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.demo.macro;

import java.awt.Point;
import net.officefloor.demo.macro.Macro;
import net.officefloor.demo.macro.MacroSource;
import net.officefloor.demo.macro.MacroSourceContext;
import net.officefloor.demo.macro.MacroTask;
import net.officefloor.demo.macro.MacroTaskContext;

public class MoveMouseMacro
implements MacroSource,
Macro,
MacroTask {
    private Point location;

    @Override
    public String getDisplayName() {
        return "Move mouse";
    }

    @Override
    public void sourceMacro(MacroSourceContext context) {
        MoveMouseMacro macro = new MoveMouseMacro();
        macro.location = context.getLocation();
        context.setNewMacro(macro);
    }

    @Override
    public void setConfigurationMemento(String memento) {
        String[] coordinates = memento.split(",");
        int x = Integer.parseInt(coordinates[0]);
        int y = Integer.parseInt(coordinates[1]);
        this.location = new Point(x, y);
    }

    @Override
    public String getConfigurationMemento() {
        return String.valueOf(this.location.x) + "," + String.valueOf(this.location.y);
    }

    @Override
    public String getDisplayLabel() {
        return "MouseMove (" + this.location.x + "," + this.location.y + ")";
    }

    @Override
    public Point getStartingMouseLocation() {
        return this.location;
    }

    @Override
    public MacroTask[] getMacroTasks() {
        return new MacroTask[]{this};
    }

    @Override
    public void runMacroTask(MacroTaskContext context) {
    }

    @Override
    public long getPostRunWaitTime() {
        return 0L;
    }
}

