/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.demo.gui;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.officefloor.demo.gui.DemoTool;
import net.officefloor.demo.macro.Macro;
import net.officefloor.demo.macrolist.MacroList;
import net.officefloor.demo.store.MacroStore;

public class SaveButton
extends JButton {
    public SaveButton(final DemoTool demo, final Frame frame) {
        super("Save");
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileFilter(new FileNameExtensionFilter("Recording file", "rcd"));
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.setFileSelectionMode(0);
                switch (chooser.showSaveDialog(frame)) {
                    case 0: {
                        break;
                    }
                    default: {
                        return;
                    }
                }
                File saveFile = chooser.getSelectedFile();
                String extension = ".rcd";
                if (!saveFile.getName().endsWith(extension)) {
                    saveFile = new File(saveFile.getParent(), saveFile.getName() + extension);
                }
                if (saveFile.exists()) {
                    switch (JOptionPane.showConfirmDialog(frame, "Overwrite file?")) {
                        case 0: {
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
                LinkedList<Macro> macros = new LinkedList<Macro>();
                MacroList macroList = demo.getMacroList();
                for (int i = 0; i < macroList.size(); ++i) {
                    macros.add(macroList.getItem(i).getMacro());
                }
                try {
                    FileWriter writer = new FileWriter(saveFile);
                    new MacroStore().store(macros.toArray(new Macro[0]), writer);
                    writer.close();
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(frame, "Failed to store recording to file: " + ex.getMessage() + " [" + ex.getClass().getSimpleName() + "]");
                }
            }
        });
    }
}

