/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.demo.play;

import java.awt.AWTException;
import java.awt.Point;
import java.awt.Robot;
import javax.swing.SwingUtilities;
import net.officefloor.demo.macro.Macro;
import net.officefloor.demo.macro.MacroTask;
import net.officefloor.demo.macro.MacroTaskContext;

public class MacroPlayer
implements MacroTaskContext {
    private static final int MIN_PRESS_RELEASE_DELAY = 10;
    private final Robot robot;
    private final Point offset;
    private Point mouseLocation = null;
    private final boolean isRequirePressReleaseDelay;

    public static int[] getCharacterKeyCodes(char character) throws UnsupportedOperationException {
        if ('0' <= character && character <= '9') {
            return new int[]{character - 48 + 48};
        }
        if ('a' <= character && character <= 'z') {
            return new int[]{character - 97 + 65};
        }
        if ('A' <= character && character <= 'Z') {
            return new int[]{16, character - 65 + 65};
        }
        switch (character) {
            case ' ': {
                return new int[]{32};
            }
            case '.': {
                return new int[]{46};
            }
            case '/': {
                return new int[]{47};
            }
            case ':': {
                return new int[]{16, 513};
            }
        }
        throw new UnsupportedOperationException("Unsupported character '" + character + "'");
    }

    public MacroPlayer(int delay, Point offset) throws AWTException {
        this.robot = new Robot();
        this.robot.setAutoDelay(delay);
        this.offset = offset;
        this.isRequirePressReleaseDelay = delay < 10;
    }

    public MacroPlayer(Robot robot, Point offset) {
        this.robot = robot;
        this.offset = offset;
        this.isRequirePressReleaseDelay = true;
    }

    public void play(final Macro ... macros) {
        Runnable player = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                try {
                    Macro[] arr$ = macros;
                    int len$ = arr$.length;
                    int i$ = 0;
                    while (i$ < len$) {
                        Macro macro = arr$[i$];
                        final Point startLocation = macro.getStartingMouseLocation();
                        MacroTask[] tasks = macro.getMacroTasks();
                        boolean isFirstTask = true;
                        for (final MacroTask task : tasks) {
                            Thread.sleep(10L);
                            MacroPlayer.this.robot.waitForIdle();
                            final boolean[] isRun = new boolean[]{false};
                            final boolean isMoveToStartLocation = isFirstTask;
                            isFirstTask = false;
                            SwingUtilities.invokeAndWait(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    try {
                                        if (isMoveToStartLocation && startLocation != null) {
                                            MacroPlayer.this.mouseMove(startLocation.x, startLocation.y);
                                        }
                                        task.runMacroTask(MacroPlayer.this);
                                    }
                                    finally {
                                        boolean[] blArray = isRun;
                                        synchronized (isRun) {
                                            isRun[0] = true;
                                            isRun.notify();
                                            // ** MonitorExit[var1_1] (shouldn't be in output)
                                        }
                                    }
                                }
                            });
                            boolean[] blArray = isRun;
                            // MONITORENTER : isRun
                            while (!isRun[0]) {
                                isRun.wait(100L);
                            }
                            // MONITOREXIT : blArray
                            Thread.sleep(10L);
                            MacroPlayer.this.robot.waitForIdle();
                            long taskWaitTime = task.getPostRunWaitTime();
                            if (taskWaitTime <= 0L) continue;
                            Thread.sleep(taskWaitTime);
                        }
                        ++i$;
                    }
                    return;
                }
                catch (Throwable ex) {
                    System.err.println("Failed playing macros");
                    ex.printStackTrace();
                }
            }
        };
        new Thread(player).start();
    }

    private void moveMouse(Point start, Point end) {
        this.robot.mouseMove(start.x, end.y);
        int width = end.x - start.x;
        int height = end.y - start.y;
        if (width == 0 && height == 0) {
            return;
        }
        int distance = (int)Math.sqrt(Math.abs(width * width) + Math.abs(height * height));
        float widthIncrement = (float)width / (float)distance;
        float heightIncrement = (float)height / (float)distance;
        float xLocation = start.x;
        float yLocation = start.y;
        for (int i = 0; i < distance; ++i) {
            this.robot.mouseMove((int)(xLocation += widthIncrement), (int)(yLocation += heightIncrement));
        }
        this.robot.mouseMove(end.x, end.y);
    }

    private void delayForPressRelease() {
        if (this.isRequirePressReleaseDelay) {
            this.robot.delay(10);
        }
    }

    @Override
    public void mouseMove(int x, int y) {
        Point location = this.getAbsoluteLocation(new Point(x, y));
        if (this.mouseLocation == null) {
            this.robot.mouseMove(location.x, location.y);
            this.mouseLocation = location;
        } else {
            this.moveMouse(this.mouseLocation, location);
            this.mouseLocation = location;
        }
    }

    @Override
    public void mousePress(int buttons) {
        this.robot.mousePress(buttons);
        this.delayForPressRelease();
    }

    @Override
    public void mouseRelease(int buttons) {
        this.robot.mouseRelease(buttons);
        this.delayForPressRelease();
    }

    @Override
    public void mouseClick(int buttons) {
        this.mousePress(buttons);
        this.mouseRelease(buttons);
    }

    @Override
    public void mouseWheel(int wheelAmt) {
        this.robot.mouseWheel(wheelAmt);
        this.delayForPressRelease();
    }

    @Override
    public void keyPress(int keycode) {
        this.robot.keyPress(keycode);
        this.delayForPressRelease();
    }

    @Override
    public void keyRelease(int keycode) {
        this.robot.keyRelease(keycode);
        this.delayForPressRelease();
    }

    @Override
    public void keyStroke(int keycode) {
        this.keyPress(keycode);
        this.keyRelease(keycode);
    }

    @Override
    public void keyText(String text) {
        for (int i = 0; i < text.length(); ++i) {
            int k;
            char character = text.charAt(i);
            int[] keyCodes = MacroPlayer.getCharacterKeyCodes(character);
            for (k = 0; k < keyCodes.length; ++k) {
                this.keyPress(keyCodes[k]);
            }
            for (k = keyCodes.length - 1; k >= 0; --k) {
                this.keyRelease(keyCodes[k]);
            }
        }
    }

    @Override
    public Point getAbsoluteLocation(Point relativeLocation) {
        return new Point(this.offset.x + relativeLocation.x, this.offset.y + relativeLocation.y);
    }

    @Override
    public Point getRelativeLocation(Point absoluteLocation) {
        return new Point(absoluteLocation.x - this.offset.x, absoluteLocation.y - this.offset.y);
    }
}

