/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.demo.gui;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import net.officefloor.demo.gui.DeleteButton;
import net.officefloor.demo.gui.OpenButton;
import net.officefloor.demo.gui.PlayButton;
import net.officefloor.demo.gui.SaveButton;
import net.officefloor.demo.macro.CommentMacro;
import net.officefloor.demo.macro.DragMacro;
import net.officefloor.demo.macro.InfoMacro;
import net.officefloor.demo.macro.InputTextMacro;
import net.officefloor.demo.macro.LeftClickMacro;
import net.officefloor.demo.macro.Macro;
import net.officefloor.demo.macro.MacroSource;
import net.officefloor.demo.macro.MoveMouseMacro;
import net.officefloor.demo.macro.PauseMacro;
import net.officefloor.demo.macro.RightClickMacro;
import net.officefloor.demo.macrolist.MacroIndexFactory;
import net.officefloor.demo.macrolist.MacroItem;
import net.officefloor.demo.macrolist.MacroList;
import net.officefloor.demo.macrolist.MacroListListener;
import net.officefloor.demo.record.FrameVisibilityListener;
import net.officefloor.demo.record.RecordComponent;

public class DemoTool
implements MacroIndexFactory {
    private static final Dimension DEFAULT_RECORDING_SIZE = new Dimension(1024, 550);
    public static final String RECORDING_FILE_EXTENSION = "rcd";
    private RecordComponent recordComponent;
    private MacroList macros;
    private JList macroList;

    public static void main(String[] args) throws AWTException {
        Frame frame = new Frame("Demo Tool");
        new DemoTool().attachComponents(frame, null, frame, new MacroSource[0]);
        frame.setVisible(true);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        frame.setLocation(Math.abs(screenSize.width - frameSize.width) / 2, Math.abs(screenSize.height - frameSize.height) / 2);
    }

    public void attachComponents(final Frame frame, FrameVisibilityListener visibilityListener, Container container, MacroSource ... macroSources) throws AWTException {
        if (this.recordComponent != null) {
            throw new IllegalStateException("Can only attach once to a Frame.  Please create another instance for use.");
        }
        frame.addWindowListener(new WindowAdapter(){
            private boolean isDisposed = false;

            @Override
            public void windowClosing(WindowEvent e) {
                if (!this.isDisposed) {
                    frame.dispose();
                    this.isDisposed = true;
                }
            }
        });
        ConfiguredPanel panel = new ConfiguredPanel(true, container);
        final DefaultListModel macroListModel = new DefaultListModel();
        this.macros = new MacroList(this, new MacroListListener(){

            @Override
            public void macroAdded(MacroItem item, int index) {
                Macro macro = item.getMacro();
                String displayLabel = macro.getDisplayLabel();
                if (displayLabel == null || displayLabel.trim().length() == 0) {
                    displayLabel = macro.getClass().getSimpleName();
                }
                macroListModel.add(index, displayLabel);
                frame.pack();
            }

            @Override
            public void macroRemoved(MacroItem item, int index) {
                macroListModel.remove(index);
                frame.pack();
            }
        });
        ConfiguredPanel recordPanel = new ConfiguredPanel(false, panel);
        this.recordComponent = new RecordComponent(new Robot(), frame, visibilityListener, this.macros);
        this.recordComponent.setBorder(new LineBorder(Color.RED));
        Dimension recorderSize = DEFAULT_RECORDING_SIZE;
        this.recordComponent.setMinimumSize(recorderSize);
        this.recordComponent.setPreferredSize(recorderSize);
        this.recordComponent.setMaximumSize(recorderSize);
        recordPanel.add(this.recordComponent);
        ConfiguredPanel markerPanel = new ConfiguredPanel(true, recordPanel);
        markerPanel.add(Box.createHorizontalStrut(100));
        markerPanel.add(new JLabel("|"));
        markerPanel.add(Box.createHorizontalGlue());
        this.recordComponent.addMacro(new CommentMacro());
        this.recordComponent.addMacro(new LeftClickMacro());
        this.recordComponent.addMacro(new RightClickMacro());
        this.recordComponent.addMacro(new MoveMouseMacro());
        this.recordComponent.addMacro(new DragMacro());
        this.recordComponent.addMacro(new InputTextMacro());
        this.recordComponent.addMacro(new InfoMacro());
        this.recordComponent.addMacro(new PauseMacro());
        for (MacroSource source : macroSources) {
            this.recordComponent.addMacro(source);
        }
        ConfiguredPanel controlPanel = new ConfiguredPanel(false, panel);
        ConfiguredPanel macroPanel = new ConfiguredPanel(false, controlPanel);
        ConfiguredPanel macroLabelPanel = new ConfiguredPanel(true, macroPanel);
        macroLabelPanel.add(new JLabel("Macros"));
        macroPanel.add(Box.createVerticalStrut(5));
        this.macroList = new JList(macroListModel);
        JScrollPane macroScrollPane = new JScrollPane(this.macroList);
        macroScrollPane.setBorder(new LineBorder(Color.BLACK));
        macroPanel.add(macroScrollPane);
        controlPanel.add(Box.createVerticalStrut(20));
        ConfiguredPanel unselectPanel = new ConfiguredPanel(true, controlPanel);
        JButton unselectButton = new JButton("Unselect");
        unselectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DemoTool.this.macroList.clearSelection();
            }
        });
        unselectPanel.add(unselectButton);
        unselectPanel.add(Box.createHorizontalGlue());
        controlPanel.add(Box.createVerticalStrut(20));
        ConfiguredPanel playPanel = new ConfiguredPanel(true, controlPanel);
        playPanel.add(new PlayButton(this, frame, this.recordComponent));
        playPanel.add(Box.createHorizontalGlue());
        controlPanel.add(Box.createVerticalStrut(20));
        ConfiguredPanel saveOpenPanel = new ConfiguredPanel(true, controlPanel);
        saveOpenPanel.add(new SaveButton(this, frame));
        saveOpenPanel.add(new OpenButton(this, frame));
        controlPanel.add(Box.createVerticalStrut(20));
        ConfiguredPanel deletePanel = new ConfiguredPanel(true, controlPanel);
        deletePanel.add(new DeleteButton(this, frame));
        deletePanel.add(Box.createHorizontalGlue());
        frame.pack();
    }

    public Rectangle getRecordingArea() {
        return this.recordComponent.getRecordingArea();
    }

    public Macro[] getSelectedMacros(boolean isReturnAllIfNoneSelected) {
        LinkedList<Macro> selectedMacros = new LinkedList<Macro>();
        for (int index : this.macroList.getSelectedIndices()) {
            Macro macro = this.macros.getItem(index).getMacro();
            selectedMacros.add(macro);
        }
        if (isReturnAllIfNoneSelected && selectedMacros.size() == 0) {
            for (int i = 0; i < this.macros.size(); ++i) {
                Macro macro = this.macros.getItem(i).getMacro();
                selectedMacros.add(macro);
            }
        }
        return selectedMacros.toArray(new Macro[0]);
    }

    public int[] getSelectedMacroIndices() {
        return this.macroList.getSelectedIndices();
    }

    public MacroList getMacroList() {
        return this.macros;
    }

    @Override
    public int createMacroIndex() {
        int[] selectedIndices = this.getSelectedMacroIndices();
        if (selectedIndices.length == 1) {
            int index = selectedIndices[0] + 1;
            return index;
        }
        return -1;
    }

    private class ConfiguredPanel
    extends JPanel {
        public ConfiguredPanel(boolean isHorizontal, Container container) {
            BoxLayout layout = new BoxLayout(this, isHorizontal ? 0 : 1);
            this.setLayout(layout);
            container.add(this);
        }
    }
}

