/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.demo.macro;

import java.awt.Point;
import net.officefloor.demo.macro.Macro;
import net.officefloor.demo.macro.MacroSource;
import net.officefloor.demo.macro.MacroSourceContext;
import net.officefloor.demo.macro.MacroTask;
import net.officefloor.demo.macro.MacroTaskContext;

public class LeftClickMacro
implements MacroSource,
Macro,
MacroTask {
    private Point location;

    @Override
    public String getDisplayName() {
        return "Left Click";
    }

    @Override
    public void sourceMacro(MacroSourceContext context) {
        LeftClickMacro macro = new LeftClickMacro();
        macro.location = context.getLocation();
        context.setNewMacro(macro);
    }

    @Override
    public void setConfigurationMemento(String memento) {
        String[] coordinates = memento.split(",");
        int x = Integer.parseInt(coordinates[0]);
        int y = Integer.parseInt(coordinates[1]);
        this.location = new Point(x, y);
    }

    @Override
    public String getConfigurationMemento() {
        return String.valueOf(this.location.x) + "," + String.valueOf(this.location.y);
    }

    @Override
    public String getDisplayLabel() {
        return "LeftClick (" + this.location.x + "," + this.location.y + ")";
    }

    @Override
    public Point getStartingMouseLocation() {
        return this.location;
    }

    @Override
    public MacroTask[] getMacroTasks() {
        return new MacroTask[]{this};
    }

    @Override
    public void runMacroTask(MacroTaskContext context) {
        context.mouseMove(this.location.x, this.location.y);
        context.mouseClick(16);
    }

    @Override
    public long getPostRunWaitTime() {
        return 100L;
    }
}

