/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.demo.macro;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JTextArea;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.border.LineBorder;
import net.officefloor.demo.macro.Macro;
import net.officefloor.demo.macro.MacroSource;
import net.officefloor.demo.macro.MacroSourceContext;
import net.officefloor.demo.macro.MacroTask;
import net.officefloor.demo.macro.MacroTaskContext;

public class InfoMacro
implements MacroSource,
Macro {
    private Point macroLocation = null;
    private String macroInfoText = null;

    public Point getInfoLocation() {
        return this.macroLocation;
    }

    public String getInfoText() {
        return this.macroInfoText;
    }

    @Override
    public String getDisplayName() {
        return "Info";
    }

    @Override
    public void sourceMacro(MacroSourceContext context) {
        Point relativeLocation = context.getLocation();
        Point initialLocation = context.getAbsoluteLocation(relativeLocation);
        InfoDialog dialog = new InfoDialog(context.getOwnerFrame(), initialLocation);
        dialog.setVisible(true);
        Point infoAbsoluteLocation = dialog.getInfoLocation();
        Point infoRelativeLocation = context.getRelativeLocation(infoAbsoluteLocation);
        String infoText = dialog.getInfoText();
        InfoMacro macro = new InfoMacro();
        macro.macroLocation = infoRelativeLocation;
        macro.macroInfoText = infoText;
        context.setNewMacro(macro);
    }

    @Override
    public String getConfigurationMemento() {
        return this.macroLocation.x + "," + this.macroLocation.y + ":" + this.macroInfoText;
    }

    @Override
    public void setConfigurationMemento(String memento) {
        int split = memento.indexOf(58);
        String location = memento.substring(0, split);
        String[] point = location.split(",");
        int x = Integer.parseInt(point[0]);
        int y = Integer.parseInt(point[1]);
        this.macroLocation = new Point(x, y);
        this.macroInfoText = memento.substring(split + 1);
    }

    @Override
    public String getDisplayLabel() {
        int MAX_TEXT_LENGTH = 20;
        String information = this.macroInfoText;
        information = information.length() > 20 ? information.substring(0, 20) : information;
        return "Info: " + information;
    }

    @Override
    public Point getStartingMouseLocation() {
        return null;
    }

    @Override
    public MacroTask[] getMacroTasks() {
        ShowInfoMacroTask showTask = new ShowInfoMacroTask(this.macroLocation, this.macroInfoText);
        HideInfoMacroTask hideTask = new HideInfoMacroTask(showTask);
        return new MacroTask[]{showTask, hideTask};
    }

    private class InfoDialog
    extends JDialog {
        private final JTextArea info;
        private Point infoLocation;

        public InfoDialog(Frame owner, Point initialLocation) {
            super(owner, "Input Information", true);
            this.infoLocation = null;
            this.setDefaultCloseOperation(2);
            this.info = new JTextArea();
            this.info.setEditable(true);
            this.info.setText("");
            this.add(this.info);
            this.setLocation(initialLocation);
            this.setSize(200, 100);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    Point location = InfoDialog.this.getLocation();
                    InfoDialog.this.infoLocation = new Point(location);
                }
            });
        }

        public Point getInfoLocation() {
            return this.infoLocation;
        }

        public String getInfoText() {
            return this.info.getText();
        }
    }

    private class HideInfoMacroTask
    implements MacroTask {
        private final ShowInfoMacroTask showTask;

        public HideInfoMacroTask(ShowInfoMacroTask showTask) {
            this.showTask = showTask;
        }

        @Override
        public void runMacroTask(MacroTaskContext context) {
            this.showTask.hideInformation();
        }

        @Override
        public long getPostRunWaitTime() {
            return 0L;
        }
    }

    private class ShowInfoMacroTask
    implements MacroTask {
        private final Point location;
        private final String information;
        private Popup popup = null;

        public ShowInfoMacroTask(Point location, String information) {
            this.location = location;
            this.information = information;
        }

        public synchronized void hideInformation() {
            this.popup.hide();
        }

        @Override
        public synchronized void runMacroTask(MacroTaskContext context) {
            JTextArea information = new JTextArea(this.information);
            information.setEditable(false);
            information.setBorder(new LineBorder(Color.LIGHT_GRAY));
            information.setBackground(new Color(255, 255, 180));
            Point absoluteLocation = context.getAbsoluteLocation(this.location);
            this.popup = PopupFactory.getSharedInstance().getPopup(null, information, absoluteLocation.x, absoluteLocation.y);
            this.popup.show();
        }

        @Override
        public long getPostRunWaitTime() {
            int wordCount = this.information.split(" ").length;
            long waitTime = Math.max(wordCount * 300, 1000);
            return waitTime;
        }
    }
}

