/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.demo.store;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedList;
import net.officefloor.demo.macro.Macro;
import net.officefloor.demo.store.MacroRetrieveException;

public class MacroStore {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String EOL_TOKEN = "{n}";

    public void store(Macro[] macros, Writer writer) throws IOException {
        for (Macro macro : macros) {
            String className = macro.getClass().getPackage().equals(Macro.class.getPackage()) ? macro.getClass().getSimpleName() : macro.getClass().getName();
            String memento = macro.getConfigurationMemento();
            memento = memento.replace(LINE_SEPARATOR, EOL_TOKEN);
            writer.write(className + ":" + memento + "\n");
        }
    }

    public Macro[] retrieve(Reader reader) throws IOException, MacroRetrieveException {
        String line;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        BufferedReader content = new BufferedReader(reader);
        LinkedList<Macro> macros = new LinkedList<Macro>();
        while ((line = content.readLine()) != null) {
            Object object;
            if ((line = line.trim()).length() == 0) continue;
            int separatorIndex = line.indexOf(58);
            if (separatorIndex < 0) {
                throw new IOException("Invalid line [" + line + "]");
            }
            String className = line.substring(0, separatorIndex);
            String configuration = line.substring(separatorIndex + 1);
            Class<?> clazz = this.loadClass(className, classLoader);
            if (clazz == null) {
                clazz = this.loadClass(Macro.class.getPackage().getName() + "." + className, classLoader);
            }
            if (clazz == null) {
                throw new MacroRetrieveException("Could not find macro class '" + className + "'");
            }
            try {
                object = clazz.newInstance();
            }
            catch (Exception ex) {
                throw new MacroRetrieveException("Failed to instantiate macro " + clazz.getName(), ex);
            }
            if (!(object instanceof Macro)) {
                throw new MacroRetrieveException("Macro " + object.getClass().getName() + " must implement " + Macro.class.getName());
            }
            Macro macro = (Macro)object;
            configuration = configuration.replace(EOL_TOKEN, LINE_SEPARATOR);
            macro.setConfigurationMemento(configuration);
            macros.add(macro);
        }
        return macros.toArray(new Macro[0]);
    }

    private Class<?> loadClass(String className, ClassLoader classLoader) {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

