/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.demo.macrolist;

import java.util.ArrayList;
import java.util.List;
import net.officefloor.demo.macro.Macro;
import net.officefloor.demo.macrolist.MacroIndexFactory;
import net.officefloor.demo.macrolist.MacroItem;
import net.officefloor.demo.macrolist.MacroListListener;
import net.officefloor.demo.record.RecordListener;

public class MacroList
implements RecordListener {
    private final List<MacroItem> items = new ArrayList<MacroItem>();
    private final MacroListListener listener;
    private final MacroIndexFactory indexFactory;

    public MacroList(MacroIndexFactory indexFactory, MacroListListener listener) {
        this.indexFactory = indexFactory;
        this.listener = listener;
    }

    public int size() {
        return this.items.size();
    }

    public MacroItem getItem(int index) throws IndexOutOfBoundsException {
        return this.items.get(index);
    }

    public void removeItem(int index) throws IndexOutOfBoundsException {
        MacroItem item = this.items.remove(index);
        this.listener.macroRemoved(item, index);
    }

    @Override
    public void addMacro(Macro macro) {
        int specifiedIndex;
        MacroItemImpl item = new MacroItemImpl(macro);
        int index = this.items.size();
        if (this.indexFactory != null && (specifiedIndex = this.indexFactory.createMacroIndex()) >= 0) {
            index = specifiedIndex;
        }
        this.items.add(index, item);
        this.listener.macroAdded(item, index);
    }

    private static class MacroItemImpl
    implements MacroItem {
        private final Macro macro;

        public MacroItemImpl(Macro macro) {
            this.macro = macro;
        }

        @Override
        public Macro getMacro() {
            return this.macro;
        }
    }
}

