/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.demo.gui;

import java.awt.AWTException;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import net.officefloor.demo.gui.DemoTool;
import net.officefloor.demo.macro.Macro;
import net.officefloor.demo.play.MacroPlayer;
import net.officefloor.demo.record.RecordComponent;

public class PlayButton
extends JButton {
    public PlayButton(final DemoTool demo, final Frame frame, final RecordComponent recordComponent) {
        super("Play");
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Macro[] macros = demo.getSelectedMacros(true);
                    Point offset = recordComponent.getLocationOnScreen();
                    Macro hideMacro = recordComponent.getHideFrameMacro();
                    Macro showMacro = recordComponent.getShowFrameMacro();
                    Macro[] runMacros = new Macro[macros.length + 2];
                    runMacros[0] = hideMacro;
                    for (int i = 0; i < macros.length; ++i) {
                        runMacros[i + 1] = macros[i];
                    }
                    runMacros[runMacros.length - 1] = showMacro;
                    MacroPlayer player = new MacroPlayer(5, offset);
                    player.play(runMacros);
                }
                catch (AWTException ex) {
                    JOptionPane.showMessageDialog(frame, "Failed to initiate player: " + ex.getMessage() + " [" + ex.getClass().getSimpleName() + "]", "Player error", 0);
                }
            }
        });
    }
}

