/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.demo.gui;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import net.officefloor.demo.gui.DemoTool;
import net.officefloor.demo.macrolist.MacroList;

public class DeleteButton
extends JButton {
    public DeleteButton(final DemoTool demo, final Frame frame) {
        super("Delete");
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indices = demo.getSelectedMacroIndices();
                if (indices == null || indices.length == 0) {
                    JOptionPane.showMessageDialog(frame, "Please select macros for deletion");
                    return;
                }
                StringBuilder text = new StringBuilder();
                text.append("Please confirm deletion of macros:");
                for (int index : indices) {
                    text.append(" ");
                    text.append(index);
                }
                switch (JOptionPane.showConfirmDialog(frame, text.toString())) {
                    case 0: {
                        MacroList macros = demo.getMacroList();
                        for (int i = indices.length - 1; i >= 0; --i) {
                            macros.removeItem(indices[i]);
                        }
                        break;
                    }
                }
            }
        });
    }
}

