/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.demo.macro;

import java.awt.Point;
import net.officefloor.demo.macro.Macro;
import net.officefloor.demo.macro.MacroSource;
import net.officefloor.demo.macro.MacroSourceContext;
import net.officefloor.demo.macro.MacroTask;
import net.officefloor.demo.macro.MacroTaskContext;

public class DragMacro
implements MacroSource,
Macro {
    private Point itemPosition;
    private Point targetPosition;

    public Point getTargetLocation() {
        return this.targetPosition;
    }

    @Override
    public String getDisplayName() {
        return "Drag";
    }

    @Override
    public void sourceMacro(final MacroSourceContext context) {
        final Point itemLocation = context.getLocation();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Point targetLocation = context.getAnotherLocation();
                DragMacro macro = new DragMacro();
                macro.itemPosition = itemLocation;
                macro.targetPosition = targetLocation;
                context.setNewMacro(macro);
            }
        };
        new Thread(runnable).start();
    }

    @Override
    public String getConfigurationMemento() {
        String memento = this.itemPosition.x + "," + this.itemPosition.y + "-" + this.targetPosition.x + "," + this.targetPosition.y;
        return memento;
    }

    @Override
    public void setConfigurationMemento(String memento) {
        String[] positions = memento.split("-");
        String itemText = positions[0];
        String[] itemCoordinates = itemText.split(",");
        int itemX = Integer.parseInt(itemCoordinates[0]);
        int itemY = Integer.parseInt(itemCoordinates[1]);
        this.itemPosition = new Point(itemX, itemY);
        String targetText = positions[1];
        String[] targetCoordinates = targetText.split(",");
        int targetX = Integer.parseInt(targetCoordinates[0]);
        int targetY = Integer.parseInt(targetCoordinates[1]);
        this.targetPosition = new Point(targetX, targetY);
    }

    @Override
    public String getDisplayLabel() {
        return "Drag (" + this.itemPosition.x + "," + this.itemPosition.y + " - " + this.targetPosition.x + "," + this.targetPosition.y + ")";
    }

    @Override
    public Point getStartingMouseLocation() {
        return this.itemPosition;
    }

    @Override
    public MacroTask[] getMacroTasks() {
        return new MacroTask[]{new MouseClickMacroTask(true), new MouseMoveMacroTask(this.targetPosition), new MouseClickMacroTask(false)};
    }

    private static class MouseMoveMacroTask
    implements MacroTask {
        private final Point targetPosition;

        public MouseMoveMacroTask(Point targetPosition) {
            this.targetPosition = targetPosition;
        }

        @Override
        public void runMacroTask(MacroTaskContext context) {
            context.mouseMove(this.targetPosition.x, this.targetPosition.y);
        }

        @Override
        public long getPostRunWaitTime() {
            return 0L;
        }
    }

    private static class MouseClickMacroTask
    implements MacroTask {
        private final boolean isPressNotRelease;

        public MouseClickMacroTask(boolean isPressNotRelease) {
            this.isPressNotRelease = isPressNotRelease;
        }

        @Override
        public void runMacroTask(MacroTaskContext context) {
            if (this.isPressNotRelease) {
                context.mousePress(16);
            } else {
                context.mouseRelease(16);
            }
        }

        @Override
        public long getPostRunWaitTime() {
            return 0L;
        }
    }
}

