/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.demo.gui;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.officefloor.demo.gui.DemoTool;
import net.officefloor.demo.macro.Macro;
import net.officefloor.demo.macrolist.MacroList;
import net.officefloor.demo.store.MacroStore;

public class OpenButton
extends JButton {
    public OpenButton(final DemoTool demo, final Frame frame) {
        super("Open");
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Macro[] macros;
                JFileChooser chooser = new JFileChooser();
                chooser.setFileFilter(new FileNameExtensionFilter("Recording file", "rcd"));
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.setFileSelectionMode(0);
                switch (chooser.showSaveDialog(frame)) {
                    case 0: {
                        break;
                    }
                    default: {
                        return;
                    }
                }
                File openFile = chooser.getSelectedFile();
                try {
                    FileReader reader = new FileReader(openFile);
                    macros = new MacroStore().retrieve(reader);
                    reader.close();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(frame, "Failed to load macros: " + ex.getMessage() + " [" + ex.getClass().getSimpleName() + "]");
                    return;
                }
                MacroList macroList = demo.getMacroList();
                for (Macro macro : macros) {
                    macroList.addMacro(macro);
                }
            }
        });
    }
}

