/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.section;

import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import net.officefloor.eclipse.configurer.TextBuilder;
import net.officefloor.eclipse.configurer.ValueValidator;
import net.officefloor.eclipse.editor.AdaptedChildVisualFactoryContext;
import net.officefloor.eclipse.editor.DefaultConnectors;
import net.officefloor.eclipse.ide.editor.AbstractConfigurableItem;
import net.officefloor.eclipse.ide.editor.AbstractItem;
import net.officefloor.eclipse.section.FunctionEscalationItem;
import net.officefloor.eclipse.section.FunctionFlowItem;
import net.officefloor.eclipse.section.SectionEditor;
import net.officefloor.model.ConnectionModel;
import net.officefloor.model.section.ExternalFlowModel;
import net.officefloor.model.section.FunctionEscalationToFunctionModel;
import net.officefloor.model.section.FunctionFlowToFunctionModel;
import net.officefloor.model.section.FunctionModel;
import net.officefloor.model.section.FunctionToNextExternalFlowModel;
import net.officefloor.model.section.FunctionToNextFunctionModel;
import net.officefloor.model.section.FunctionToNextSubSectionInputModel;
import net.officefloor.model.section.ManagedFunctionToFunctionModel;
import net.officefloor.model.section.SectionChanges;
import net.officefloor.model.section.SectionModel;
import net.officefloor.model.section.SubSectionInputModel;
import net.officefloor.model.section.SubSectionOutputToFunctionModel;

public class FunctionItem
extends AbstractConfigurableItem<SectionModel, SectionModel.SectionEvent, SectionChanges, FunctionModel, FunctionModel.FunctionEvent, FunctionItem> {
    private String name;

    public static void main(String[] args) {
        SectionEditor.launchConfigurer(new FunctionItem(), null);
    }

    public FunctionModel prototype() {
        return new FunctionModel("Function", false, null, null, null);
    }

    protected FunctionItem item(FunctionModel model) {
        FunctionItem item = new FunctionItem();
        if (model != null) {
            item.name = model.getFunctionName();
        }
        return item;
    }

    public AbstractItem.IdeExtractor extract() {
        return new AbstractItem.IdeExtractor((AbstractItem)this, parent -> parent.getFunctions(), (Enum[])new SectionModel.SectionEvent[]{SectionModel.SectionEvent.ADD_FUNCTION, SectionModel.SectionEvent.REMOVE_FUNCTION});
    }

    public void loadToParent(SectionModel parentModel, FunctionModel itemModel) {
        parentModel.addFunction(itemModel);
    }

    public Pane visual(FunctionModel model, AdaptedChildVisualFactoryContext<FunctionModel> context) {
        VBox container = new VBox();
        HBox heading = (HBox)context.addNode((Pane)container, (Node)new HBox());
        context.addNode((Pane)heading, context.connector(DefaultConnectors.FLOW, new Class[]{ManagedFunctionToFunctionModel.class, SubSectionOutputToFunctionModel.class, FunctionFlowToFunctionModel.class, FunctionEscalationToFunctionModel.class}).target(new Class[]{FunctionToNextFunctionModel.class}).getNode());
        context.label((Pane)heading);
        context.addNode((Pane)heading, context.connector(DefaultConnectors.FLOW, new Class[]{FunctionToNextExternalFlowModel.class, FunctionToNextSubSectionInputModel.class}).source(new Class[]{FunctionToNextFunctionModel.class}).getNode());
        context.addNode((Pane)container, (Node)((VBox)context.childGroup("outputs", (Pane)new VBox())));
        return container;
    }

    public AbstractItem.IdeLabeller label() {
        return new AbstractItem.IdeLabeller((AbstractItem)this, model -> model.getFunctionName(), (Enum[])new FunctionModel.FunctionEvent[]{FunctionModel.FunctionEvent.CHANGE_FUNCTION_NAME});
    }

    public String style() {
        return new AbstractItem.IdeStyle((AbstractItem)this).rule("-fx-background-color", "lightblue").toString();
    }

    public AbstractConfigurableItem.IdeConfigurer configure() {
        return new AbstractConfigurableItem.IdeConfigurer((AbstractConfigurableItem)this).refactor((builder, context) -> {
            builder.title("Function");
            ((TextBuilder)((TextBuilder)builder.text("Name").init(item -> item.name)).validate(ValueValidator.notEmptyString((String)"Must provide name"))).setValue((item, value) -> {
                String string = item.name = value;
            });
            builder.apply("Refactor", item -> context.execute(((SectionChanges)context.getOperations()).renameFunction((FunctionModel)context.getModel(), item.name)));
        }).delete(context -> context.execute(((SectionChanges)context.getOperations()).removeFunction((FunctionModel)context.getModel())));
    }

    protected void children(List<AbstractItem.IdeChildrenGroup> childGroups) {
        childGroups.add(new AbstractItem.IdeChildrenGroup((AbstractItem)this, "outputs", new AbstractItem[]{new FunctionFlowItem(), new FunctionEscalationItem()}));
    }

    protected void connections(List<AbstractItem.IdeConnectionTarget<? extends ConnectionModel, ?, ?>> connections) {
        connections.add(new AbstractItem.IdeConnection((AbstractItem)this, FunctionToNextExternalFlowModel.class).connectOne(s -> s.getNextExternalFlow(), c -> c.getPreviousFunction(), (Enum[])new FunctionModel.FunctionEvent[]{FunctionModel.FunctionEvent.CHANGE_NEXT_EXTERNAL_FLOW}).to(ExternalFlowModel.class).many(t -> t.getPreviousFunctions(), c -> c.getNextExternalFlow(), new Enum[]{ExternalFlowModel.ExternalFlowEvent.ADD_PREVIOUS_FUNCTION, ExternalFlowModel.ExternalFlowEvent.REMOVE_PREVIOUS_FUNCTION}).create((s, t, ctx) -> ctx.getChangeExecutor().execute(((SectionChanges)ctx.getOperations()).linkFunctionToNextExternalFlow(s, t))).delete(ctx -> ctx.getChangeExecutor().execute(((SectionChanges)ctx.getOperations()).removeFunctionToNextExternalFlow((FunctionToNextExternalFlowModel)ctx.getModel()))));
        connections.add(new AbstractItem.IdeConnection((AbstractItem)this, FunctionToNextFunctionModel.class).connectOne(s -> s.getNextFunction(), c -> c.getPreviousFunction(), (Enum[])new FunctionModel.FunctionEvent[]{FunctionModel.FunctionEvent.CHANGE_NEXT_FUNCTION}).to(FunctionModel.class).many(t -> t.getPreviousFunctions(), c -> c.getNextFunction(), new Enum[]{FunctionModel.FunctionEvent.ADD_PREVIOUS_FUNCTION, FunctionModel.FunctionEvent.REMOVE_PREVIOUS_FUNCTION}).create((s, t, ctx) -> ctx.getChangeExecutor().execute(((SectionChanges)ctx.getOperations()).linkFunctionToNextFunction(s, t))).delete(ctx -> ctx.getChangeExecutor().execute(((SectionChanges)ctx.getOperations()).removeFunctionToNextFunction((FunctionToNextFunctionModel)ctx.getModel()))));
        connections.add(new AbstractItem.IdeConnection((AbstractItem)this, FunctionToNextSubSectionInputModel.class).connectOne(s -> s.getNextSubSectionInput(), c -> c.getPreviousFunction(), (Enum[])new FunctionModel.FunctionEvent[]{FunctionModel.FunctionEvent.CHANGE_NEXT_SUB_SECTION_INPUT}).to(SubSectionInputModel.class).many(t -> t.getPreviousFunctions(), c -> c.getNextSubSectionInput(), new Enum[]{SubSectionInputModel.SubSectionInputEvent.ADD_PREVIOUS_FUNCTION, SubSectionInputModel.SubSectionInputEvent.REMOVE_PREVIOUS_FUNCTION}).create((s, t, ctx) -> ctx.getChangeExecutor().execute(((SectionChanges)ctx.getOperations()).linkFunctionToNextSubSectionInput(s, t))).delete(ctx -> ctx.getChangeExecutor().execute(((SectionChanges)ctx.getOperations()).removeFunctionToNextSubSectionInput((FunctionToNextSubSectionInputModel)ctx.getModel()))));
    }
}

