/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.section;

import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import net.officefloor.eclipse.configurer.ClassBuilder;
import net.officefloor.eclipse.configurer.TextBuilder;
import net.officefloor.eclipse.configurer.ValueValidator;
import net.officefloor.eclipse.editor.AdaptedChildVisualFactoryContext;
import net.officefloor.eclipse.editor.DefaultConnectors;
import net.officefloor.eclipse.ide.editor.AbstractConfigurableItem;
import net.officefloor.eclipse.ide.editor.AbstractItem;
import net.officefloor.eclipse.section.SectionEditor;
import net.officefloor.model.section.ExternalFlowModel;
import net.officefloor.model.section.FunctionEscalationToExternalFlowModel;
import net.officefloor.model.section.FunctionFlowToExternalFlowModel;
import net.officefloor.model.section.FunctionToNextExternalFlowModel;
import net.officefloor.model.section.SectionChanges;
import net.officefloor.model.section.SectionModel;
import net.officefloor.model.section.SubSectionOutputToExternalFlowModel;

public class ExternalFlowItem
extends AbstractConfigurableItem<SectionModel, SectionModel.SectionEvent, SectionChanges, ExternalFlowModel, ExternalFlowModel.ExternalFlowEvent, ExternalFlowItem> {
    private String name;
    private String argumentType;

    public static void main(String[] args) {
        SectionEditor.launchConfigurer(new ExternalFlowItem(), flow -> flow.setArgumentType(String.class.getName()));
    }

    public ExternalFlowModel prototype() {
        return new ExternalFlowModel("External Flow", null);
    }

    public AbstractItem.IdeExtractor extract() {
        return new AbstractItem.IdeExtractor((AbstractItem)this, parent -> parent.getExternalFlows(), (Enum[])new SectionModel.SectionEvent[]{SectionModel.SectionEvent.ADD_EXTERNAL_FLOW, SectionModel.SectionEvent.REMOVE_EXTERNAL_FLOW});
    }

    public void loadToParent(SectionModel parentModel, ExternalFlowModel itemModel) {
        parentModel.addExternalFlow(itemModel);
    }

    public Pane visual(ExternalFlowModel model, AdaptedChildVisualFactoryContext<ExternalFlowModel> context) {
        HBox container = new HBox();
        context.addNode((Pane)container, context.connector(DefaultConnectors.FLOW, new Class[]{FunctionToNextExternalFlowModel.class, FunctionFlowToExternalFlowModel.class, FunctionEscalationToExternalFlowModel.class, SubSectionOutputToExternalFlowModel.class}).getNode());
        context.label((Pane)container);
        return container;
    }

    public AbstractItem.IdeLabeller label() {
        return new AbstractItem.IdeLabeller((AbstractItem)this, model -> model.getExternalFlowName(), (Enum[])new ExternalFlowModel.ExternalFlowEvent[]{ExternalFlowModel.ExternalFlowEvent.CHANGE_EXTERNAL_FLOW_NAME});
    }

    public String style() {
        return new AbstractItem.IdeStyle((AbstractItem)this).rule("-fx-background-color", "orchid").toString();
    }

    protected ExternalFlowItem item(ExternalFlowModel model) {
        ExternalFlowItem item = new ExternalFlowItem();
        if (model != null) {
            item.name = model.getExternalFlowName();
            item.argumentType = model.getArgumentType();
        }
        return item;
    }

    public AbstractConfigurableItem.IdeConfigurer configure() {
        return new AbstractConfigurableItem.IdeConfigurer((AbstractConfigurableItem)this).addAndRefactor((builder, context) -> {
            builder.title("External Flow");
            ((TextBuilder)((TextBuilder)builder.text("Name").init(model -> model.name)).setValue((model, value) -> {
                String string = model.name = value;
            })).validate(ValueValidator.notEmptyString((String)"Must specify name"));
            ((ClassBuilder)builder.clazz("Argument").init(model -> model.argumentType)).setValue((model, value) -> {
                String string = model.argumentType = value;
            });
        }).add((builder, context) -> builder.apply("Add", item -> context.execute(((SectionChanges)context.getOperations()).addExternalFlow(item.name, item.argumentType)))).refactor((builder, context) -> builder.apply("Refactor", item -> {
            throw new UnsupportedOperationException("TODO renameExternalFlow to be refactorExternalFlow");
        })).delete(context -> context.execute(((SectionChanges)context.getOperations()).removeExternalFlow((ExternalFlowModel)context.getModel())));
    }
}

