/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.section;

import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import net.officefloor.compile.OfficeFloorCompiler;
import net.officefloor.compile.properties.PropertyList;
import net.officefloor.compile.section.SectionLoader;
import net.officefloor.compile.section.SectionType;
import net.officefloor.compile.spi.section.source.SectionSource;
import net.officefloor.eclipse.configurer.ChoiceBuilder;
import net.officefloor.eclipse.configurer.ClassBuilder;
import net.officefloor.eclipse.configurer.ConfigurationBuilder;
import net.officefloor.eclipse.configurer.PropertiesBuilder;
import net.officefloor.eclipse.configurer.TextBuilder;
import net.officefloor.eclipse.configurer.ValueValidator;
import net.officefloor.eclipse.editor.AdaptedChildVisualFactoryContext;
import net.officefloor.eclipse.ide.editor.AbstractConfigurableItem;
import net.officefloor.eclipse.ide.editor.AbstractItem;
import net.officefloor.eclipse.osgi.OfficeFloorOsgiBridge;
import net.officefloor.eclipse.section.SectionEditor;
import net.officefloor.eclipse.section.SubSectionInputItem;
import net.officefloor.eclipse.section.SubSectionOutputItem;
import net.officefloor.model.section.SectionChanges;
import net.officefloor.model.section.SectionModel;
import net.officefloor.model.section.SubSectionModel;
import net.officefloor.plugin.section.clazz.ClassSectionSource;

public class SubSectionItem
extends AbstractConfigurableItem<SectionModel, SectionModel.SectionEvent, SectionChanges, SubSectionModel, SubSectionModel.SubSectionEvent, SubSectionItem> {
    private static final int CHOICE_CLASS = 0;
    private String name;
    private Integer choice = null;
    private String sourceClassName;
    private String location;
    private PropertyList properties = OfficeFloorCompiler.newPropertyList();
    private SectionType sectionType;

    public static void main(String[] args) {
        SectionEditor.launchConfigurer(new SubSectionItem(), null);
    }

    public static SectionType loadSectionType(SubSectionItem item, OfficeFloorOsgiBridge osgiBridge) throws Exception {
        SectionLoader loader = osgiBridge.getOfficeFloorCompiler().getSectionLoader();
        Class sourceClass = osgiBridge.loadClass(item.sourceClassName, SectionSource.class);
        return loader.loadSectionType(sourceClass, item.location, item.properties);
    }

    public SubSectionModel prototype() {
        return new SubSectionModel("Sub Section", null, null);
    }

    public AbstractItem.IdeExtractor extract() {
        return new AbstractItem.IdeExtractor((AbstractItem)this, root -> root.getSubSections(), (Enum[])new SectionModel.SectionEvent[]{SectionModel.SectionEvent.ADD_SUB_SECTION, SectionModel.SectionEvent.REMOVE_SUB_SECTION});
    }

    public void loadToParent(SectionModel parentModel, SubSectionModel itemModel) {
        parentModel.addSubSection(itemModel);
    }

    public Pane visual(SubSectionModel model, AdaptedChildVisualFactoryContext<SubSectionModel> context) {
        VBox container = new VBox();
        context.label((Pane)container);
        HBox children = (HBox)context.addNode((Pane)container, (Node)new HBox());
        VBox inputs = (VBox)context.addNode((Pane)children, (Node)new VBox());
        context.childGroup(SubSectionInputItem.class.getSimpleName(), (Pane)inputs);
        VBox outputs = (VBox)context.addNode((Pane)children, (Node)new VBox());
        context.childGroup(SubSectionOutputItem.class.getSimpleName(), (Pane)outputs);
        return container;
    }

    public AbstractItem.IdeLabeller label() {
        return new AbstractItem.IdeLabeller((AbstractItem)this, model -> model.getSubSectionName(), (Enum[])new SubSectionModel.SubSectionEvent[]{SubSectionModel.SubSectionEvent.CHANGE_SUB_SECTION_NAME});
    }

    public String style() {
        AbstractItem.IdeStyle background = new AbstractItem.IdeStyle((AbstractItem)this).rule("-fx-background-color", "radial-gradient(radius 50.0%, darkorchid, thistle)");
        AbstractItem.IdeStyle text = new AbstractItem.IdeStyle((AbstractItem)this, ".${model} .title").rule("-fx-text-fill", "white");
        return String.valueOf(background.toString()) + text.toString();
    }

    protected SubSectionItem item(SubSectionModel model) {
        SubSectionItem item = new SubSectionItem();
        if (model != null) {
            item.name = model.getSubSectionName();
            item.sourceClassName = model.getSectionSourceClassName();
            item.location = model.getSectionLocation();
            item.properties = this.translateToPropertyList(model.getProperties(), p -> p.getName(), p -> p.getValue());
            if (ClassSectionSource.class.getName().equals(item.sourceClassName)) {
                item.choice = 0;
            }
        }
        return item;
    }

    protected void children(List<AbstractItem.IdeChildrenGroup> childGroups) {
        childGroups.add(new AbstractItem.IdeChildrenGroup((AbstractItem)this, (AbstractItem)new SubSectionInputItem()));
        childGroups.add(new AbstractItem.IdeChildrenGroup((AbstractItem)this, (AbstractItem)new SubSectionOutputItem()));
    }

    public AbstractConfigurableItem.IdeConfigurer configure() {
        return new AbstractConfigurableItem.IdeConfigurer((AbstractConfigurableItem)this).addAndRefactor((builder, context) -> {
            builder.title("Sub Section");
            ((TextBuilder)((TextBuilder)builder.text("Name").init(item -> item.name)).validate(ValueValidator.notEmptyString((String)"Must provide name"))).setValue((item, value) -> {
                String string = item.name = value;
            });
            ChoiceBuilder choices = (ChoiceBuilder)((ChoiceBuilder)((ChoiceBuilder)builder.choices("").init(item -> item.choice)).validate(ValueValidator.notNull((String)"Must select"))).setValue((item, value) -> {
                if (value == 0) {
                    item.sourceClassName = ClassSectionSource.class.getName();
                }
            });
            ConfigurationBuilder classBuilder = choices.choice("Class");
            ((ClassBuilder)((ClassBuilder)classBuilder.clazz("Class").init(item -> item.location)).validate(ValueValidator.notEmptyString((String)"Must specify class"))).setValue((item, value) -> {
                String string = item.location = value;
            });
            ConfigurationBuilder sourceBuilder = choices.choice("Source");
            ((ClassBuilder)((ClassBuilder)sourceBuilder.clazz("Source").init(item -> item.sourceClassName)).superType(SectionSource.class).validate(ValueValidator.notEmptyString((String)"Must specify source"))).setValue((item, value) -> {
                String string = item.sourceClassName = value;
            });
            ((TextBuilder)sourceBuilder.text("Location").init(item -> item.location)).setValue((item, value) -> {
                String string = item.location = value;
            });
            ((PropertiesBuilder)sourceBuilder.properties("Properties").init(item -> item.properties)).setValue((item, value) -> {
                PropertyList propertyList = item.properties = value;
            });
            builder.validate(ctx -> {
                OfficeFloorOsgiBridge osgiBridge = this.getConfigurableContext().getOsgiBridge();
                SubSectionItem item = (SubSectionItem)((Object)((Object)((Object)ctx.getModel())));
                item.sectionType = SubSectionItem.loadSectionType(item, osgiBridge);
            });
        }).add((builder, context) -> builder.apply("Add", item -> context.execute(((SectionChanges)context.getOperations()).addSubSection(item.name, item.sourceClassName, item.location, item.properties, item.sectionType)))).refactor((builder, context) -> builder.apply("Refactor", item -> {
            throw new UnsupportedOperationException("TODO implement refactoring SubSection");
        })).delete(context -> context.execute(((SectionChanges)context.getOperations()).removeSubSection((SubSectionModel)context.getModel())));
    }
}

