/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.section;

import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import net.officefloor.compile.OfficeFloorCompiler;
import net.officefloor.compile.managedobject.ManagedObjectLoader;
import net.officefloor.compile.managedobject.ManagedObjectType;
import net.officefloor.compile.properties.PropertyList;
import net.officefloor.eclipse.configurer.ChoiceBuilder;
import net.officefloor.eclipse.configurer.ClassBuilder;
import net.officefloor.eclipse.configurer.ConfigurationBuilder;
import net.officefloor.eclipse.configurer.PropertiesBuilder;
import net.officefloor.eclipse.configurer.TextBuilder;
import net.officefloor.eclipse.configurer.ValueValidator;
import net.officefloor.eclipse.editor.AdaptedChildVisualFactoryContext;
import net.officefloor.eclipse.editor.DefaultConnectors;
import net.officefloor.eclipse.editor.DefaultImages;
import net.officefloor.eclipse.ide.editor.AbstractConfigurableItem;
import net.officefloor.eclipse.ide.editor.AbstractItem;
import net.officefloor.eclipse.osgi.OfficeFloorOsgiBridge;
import net.officefloor.eclipse.section.SectionEditor;
import net.officefloor.frame.api.managedobject.source.ManagedObjectSource;
import net.officefloor.frame.internal.structure.ManagedObjectScope;
import net.officefloor.model.section.PropertyModel;
import net.officefloor.model.section.SectionChanges;
import net.officefloor.model.section.SectionManagedObjectSourceModel;
import net.officefloor.model.section.SectionManagedObjectToSectionManagedObjectSourceModel;
import net.officefloor.model.section.SectionModel;
import net.officefloor.plugin.managedobject.clazz.ClassManagedObjectSource;

public class ManagedObjectSourceItem
extends AbstractConfigurableItem<SectionModel, SectionModel.SectionEvent, SectionChanges, SectionManagedObjectSourceModel, SectionManagedObjectSourceModel.SectionManagedObjectSourceEvent, ManagedObjectSourceItem> {
    private static final int CHOICE_CLASS = 0;
    private String name;
    private Integer choice = null;
    private String sourceClassName;
    private PropertyList properties = OfficeFloorCompiler.newPropertyList();
    private long timeout = 0L;
    private ManagedObjectType<?> managedObjectType;

    public static void main(String[] args) {
        SectionEditor.launchConfigurer(new ManagedObjectSourceItem(), model -> {
            model.setManagedObjectSourceClassName(ClassManagedObjectSource.class.getName());
            model.addProperty(new PropertyModel("class.name", ManagedObjectSourceItem.class.getName()));
        });
    }

    public static ManagedObjectType<?> loadManagedObjectType(ManagedObjectSourceItem item, OfficeFloorOsgiBridge osgiBridge) throws Exception {
        ManagedObjectLoader loader = osgiBridge.getOfficeFloorCompiler().getManagedObjectLoader();
        Class sourceClass = osgiBridge.loadClass(item.sourceClassName, ManagedObjectSource.class);
        return loader.loadManagedObjectType(sourceClass, item.properties);
    }

    public SectionManagedObjectSourceModel prototype() {
        return new SectionManagedObjectSourceModel("Managed Object Source", null, null, "0");
    }

    public AbstractItem.IdeExtractor extract() {
        return new AbstractItem.IdeExtractor((AbstractItem)this, r -> r.getSectionManagedObjectSources(), (Enum[])new SectionModel.SectionEvent[]{SectionModel.SectionEvent.ADD_SECTION_MANAGED_OBJECT_SOURCE, SectionModel.SectionEvent.REMOVE_SECTION_MANAGED_OBJECT_SOURCE});
    }

    public void loadToParent(SectionModel parentModel, SectionManagedObjectSourceModel itemModel) {
        parentModel.addSectionManagedObjectSource(itemModel);
    }

    public Pane visual(SectionManagedObjectSourceModel model, AdaptedChildVisualFactoryContext<SectionManagedObjectSourceModel> context) {
        HBox container = new HBox();
        context.label((Pane)container).getStyleClass().add((Object)"title");
        context.addNode((Pane)container, context.action(ctx -> {
            SectionManagedObjectSourceModel mos = (SectionManagedObjectSourceModel)ctx.getModel();
            ManagedObjectSourceItem mosItem = new ManagedObjectSourceItem().item(mos);
            ManagedObjectType<?> moType = ManagedObjectSourceItem.loadManagedObjectType(mosItem, this.getConfigurableContext().getOsgiBridge());
            ctx.getChangeExecutor().execute(((SectionChanges)this.getConfigurableContext().getOperations()).addSectionManagedObject(mosItem.name, ManagedObjectScope.THREAD, mos, moType));
        }, DefaultImages.ADD));
        context.addNode((Pane)container, context.connector(DefaultConnectors.DERIVE, new Class[]{SectionManagedObjectToSectionManagedObjectSourceModel.class}).getNode());
        return container;
    }

    public AbstractItem.IdeLabeller label() {
        return new AbstractItem.IdeLabeller((AbstractItem)this, m -> m.getSectionManagedObjectSourceName(), (Enum[])new SectionManagedObjectSourceModel.SectionManagedObjectSourceEvent[]{SectionManagedObjectSourceModel.SectionManagedObjectSourceEvent.CHANGE_SECTION_MANAGED_OBJECT_SOURCE_NAME});
    }

    public String style() {
        return new AbstractItem.IdeStyle((AbstractItem)this).rule("-fx-background-color", "radial-gradient(radius 50.0%, green, darkseagreen)").toString();
    }

    protected ManagedObjectSourceItem item(SectionManagedObjectSourceModel model) {
        ManagedObjectSourceItem item = new ManagedObjectSourceItem();
        if (model != null) {
            item.name = model.getSectionManagedObjectSourceName();
            item.sourceClassName = model.getManagedObjectSourceClassName();
            if (ClassManagedObjectSource.class.getName().equals(item.sourceClassName)) {
                item.choice = 0;
            }
            item.properties = this.translateToPropertyList(model.getProperties(), p -> p.getName(), p -> p.getValue());
            item.timeout = Long.parseLong(model.getTimeout());
        }
        return item;
    }

    public AbstractConfigurableItem.IdeConfigurer configure() {
        return new AbstractConfigurableItem.IdeConfigurer((AbstractConfigurableItem)this).addAndRefactor((builder, context) -> {
            builder.title("Managed Object Source");
            ((TextBuilder)((TextBuilder)builder.text("Name").init(item -> item.name)).validate(ValueValidator.notEmptyString((String)"Must specify name"))).setValue((item, value) -> {
                String string = item.name = value;
            });
            ChoiceBuilder choices = (ChoiceBuilder)((ChoiceBuilder)((ChoiceBuilder)builder.choices("").init(item -> item.choice)).validate(ValueValidator.notNull((String)"Must select"))).setValue((item, value) -> {
                if (value == 0) {
                    item.sourceClassName = ClassManagedObjectSource.class.getName();
                }
            });
            ConfigurationBuilder classBuilder = choices.choice("Class");
            ((ClassBuilder)((ClassBuilder)classBuilder.clazz("Class").init(item -> item.properties.getOrAddProperty("class.name").getValue())).validate(ctx -> {
                ManagedObjectSourceItem item = (ManagedObjectSourceItem)((Object)((Object)((Object)ctx.getModel())));
                String className = item.properties.getOrAddProperty("class.name").getValue();
                ValueValidator.notEmptyString((String)className, (String)"Must specify class", (ValueValidator.ValueValidatorContext)ctx);
            })).setValue((item, value) -> item.properties.getOrAddProperty("class.name").setValue(value));
            ConfigurationBuilder sourceBuilder = choices.choice("Source");
            ((ClassBuilder)((ClassBuilder)sourceBuilder.clazz("Source").init(item -> item.sourceClassName)).superType(ManagedObjectSource.class).validate(ValueValidator.notEmptyString((String)"Must specify source"))).setValue((item, value) -> {
                String string = item.sourceClassName = value;
            });
            ((PropertiesBuilder)sourceBuilder.properties("Properties").init(item -> item.properties)).setValue((item, value) -> {
                PropertyList propertyList = item.properties = value;
            });
            builder.validate(ctx -> {
                OfficeFloorOsgiBridge osgiBridge = this.getConfigurableContext().getOsgiBridge();
                ManagedObjectSourceItem item = (ManagedObjectSourceItem)((Object)((Object)((Object)ctx.getModel())));
                item.managedObjectType = ManagedObjectSourceItem.loadManagedObjectType(item, osgiBridge);
            });
        }).add((builder, context) -> builder.apply("Add", item -> context.execute(((SectionChanges)context.getOperations()).addSectionManagedObjectSource(item.name, item.sourceClassName, item.properties, item.timeout, item.managedObjectType)))).refactor((builder, context) -> builder.apply("Refactor", item -> {
            throw new UnsupportedOperationException("TODO implement SectionChanges.refactorManagedObjectSource");
        })).delete(context -> context.execute(((SectionChanges)context.getOperations()).removeSectionManagedObjectSource((SectionManagedObjectSourceModel)context.getModel())));
    }
}

