/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.section;

import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import net.officefloor.compile.managedfunction.FunctionNamespaceType;
import net.officefloor.compile.managedfunction.ManagedFunctionType;
import net.officefloor.eclipse.editor.AdaptedChildVisualFactoryContext;
import net.officefloor.eclipse.editor.DefaultConnectors;
import net.officefloor.eclipse.editor.DefaultImages;
import net.officefloor.eclipse.ide.editor.AbstractItem;
import net.officefloor.eclipse.section.FunctionNamespaceItem;
import net.officefloor.eclipse.section.ManagedFunctionObjectItem;
import net.officefloor.model.ConnectionModel;
import net.officefloor.model.section.FunctionModel;
import net.officefloor.model.section.FunctionNamespaceModel;
import net.officefloor.model.section.ManagedFunctionModel;
import net.officefloor.model.section.ManagedFunctionToFunctionModel;
import net.officefloor.model.section.SectionChanges;
import net.officefloor.model.section.SectionModel;

public class ManagedFunctionItem
extends AbstractItem<SectionModel, SectionChanges, FunctionNamespaceModel, FunctionNamespaceModel.FunctionNamespaceEvent, ManagedFunctionModel, ManagedFunctionModel.ManagedFunctionEvent> {
    public ManagedFunctionModel prototype() {
        return new ManagedFunctionModel("Managed Function");
    }

    public AbstractItem.IdeExtractor extract() {
        return new AbstractItem.IdeExtractor((AbstractItem)this, parent -> parent.getManagedFunctions(), (Enum[])new FunctionNamespaceModel.FunctionNamespaceEvent[]{FunctionNamespaceModel.FunctionNamespaceEvent.ADD_MANAGED_FUNCTION, FunctionNamespaceModel.FunctionNamespaceEvent.REMOVE_MANAGED_FUNCTION});
    }

    public void loadToParent(FunctionNamespaceModel parentModel, ManagedFunctionModel itemModel) {
        parentModel.addManagedFunction(itemModel);
    }

    public Pane visual(ManagedFunctionModel model, AdaptedChildVisualFactoryContext<ManagedFunctionModel> context) {
        VBox container = new VBox();
        HBox heading = (HBox)context.addNode((Pane)container, (Node)new HBox());
        context.label((Pane)heading);
        context.addNode((Pane)heading, context.action(ctx -> {
            ManagedFunctionModel managedFunction = (ManagedFunctionModel)ctx.getModel();
            String functionName = managedFunction.getManagedFunctionName();
            FunctionNamespaceModel functionNamespace = (FunctionNamespaceModel)ctx.getAdaptedModel().getParent().getModel();
            FunctionNamespaceItem functionNamespaceItem = new FunctionNamespaceItem().item(functionNamespace);
            FunctionNamespaceType functionNamespaceType = FunctionNamespaceItem.loadFunctionNamespaceType(functionNamespaceItem, this.getConfigurableContext().getOsgiBridge());
            ManagedFunctionType managedFunctionType = null;
            ManagedFunctionType[] managedFunctionTypeArray = functionNamespaceType.getManagedFunctionTypes();
            int n = managedFunctionTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ManagedFunctionType type = managedFunctionTypeArray[n2];
                if (functionName.equals(type.getFunctionName())) {
                    managedFunctionType = type;
                }
                ++n2;
            }
            if (managedFunctionType == null) {
                throw new RuntimeException("Configuration out of sync");
            }
            ctx.getChangeExecutor().execute(((SectionChanges)this.getConfigurableContext().getOperations()).addFunction(functionName, managedFunction, managedFunctionType));
        }, DefaultImages.ADD));
        context.addNode((Pane)heading, context.connector(DefaultConnectors.DERIVE, new Class[]{ManagedFunctionToFunctionModel.class}).getNode());
        context.addNode((Pane)container, (Node)((VBox)context.childGroup(ManagedFunctionObjectItem.class.getSimpleName(), (Pane)new VBox())));
        return container;
    }

    public AbstractItem.IdeLabeller label() {
        return new AbstractItem.IdeLabeller((AbstractItem)this, model -> model.getManagedFunctionName(), (Enum[])new ManagedFunctionModel.ManagedFunctionEvent[]{ManagedFunctionModel.ManagedFunctionEvent.CHANGE_MANAGED_FUNCTION_NAME});
    }

    protected void children(List<AbstractItem.IdeChildrenGroup> children) {
        children.add(new AbstractItem.IdeChildrenGroup((AbstractItem)this, (AbstractItem)new ManagedFunctionObjectItem()));
    }

    protected void connections(List<AbstractItem.IdeConnectionTarget<? extends ConnectionModel, ?, ?>> connections) {
        connections.add(new AbstractItem.IdeConnection((AbstractItem)this, ManagedFunctionToFunctionModel.class).connectMany(source -> source.getFunctions(), conn -> conn.getManagedFunction(), (Enum[])new ManagedFunctionModel.ManagedFunctionEvent[]{ManagedFunctionModel.ManagedFunctionEvent.ADD_FUNCTION, ManagedFunctionModel.ManagedFunctionEvent.REMOVE_FUNCTION}).to(FunctionModel.class).one(target -> target.getManagedFunction(), conn -> conn.getFunction(), new Enum[]{FunctionModel.FunctionEvent.CHANGE_MANAGED_FUNCTION}));
    }
}

