/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.section;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import net.officefloor.compile.OfficeFloorCompiler;
import net.officefloor.compile.managedfunction.FunctionNamespaceType;
import net.officefloor.compile.managedfunction.ManagedFunctionLoader;
import net.officefloor.compile.managedfunction.ManagedFunctionType;
import net.officefloor.compile.properties.PropertyList;
import net.officefloor.compile.spi.managedfunction.source.ManagedFunctionSource;
import net.officefloor.eclipse.configurer.Builder;
import net.officefloor.eclipse.configurer.ChoiceBuilder;
import net.officefloor.eclipse.configurer.ClassBuilder;
import net.officefloor.eclipse.configurer.ConfigurationBuilder;
import net.officefloor.eclipse.configurer.FlagBuilder;
import net.officefloor.eclipse.configurer.ListBuilder;
import net.officefloor.eclipse.configurer.PropertiesBuilder;
import net.officefloor.eclipse.configurer.TextBuilder;
import net.officefloor.eclipse.configurer.ValueValidator;
import net.officefloor.eclipse.editor.AdaptedChildVisualFactoryContext;
import net.officefloor.eclipse.ide.editor.AbstractConfigurableItem;
import net.officefloor.eclipse.ide.editor.AbstractItem;
import net.officefloor.eclipse.osgi.OfficeFloorOsgiBridge;
import net.officefloor.eclipse.section.ManagedFunctionItem;
import net.officefloor.eclipse.section.SectionEditor;
import net.officefloor.model.section.FunctionNamespaceModel;
import net.officefloor.model.section.ManagedFunctionModel;
import net.officefloor.model.section.PropertyModel;
import net.officefloor.model.section.SectionChanges;
import net.officefloor.model.section.SectionModel;
import net.officefloor.plugin.managedfunction.clazz.ClassManagedFunctionSource;

public class FunctionNamespaceItem
extends AbstractConfigurableItem<SectionModel, SectionModel.SectionEvent, SectionChanges, FunctionNamespaceModel, FunctionNamespaceModel.FunctionNamespaceEvent, FunctionNamespaceItem> {
    private static final int CHOICE_CLASS = 0;
    private String name;
    private Integer choice = null;
    private String sourceClassName;
    private PropertyList properties = OfficeFloorCompiler.newPropertyList();
    private FunctionNamespaceType functionNamespaceType;
    private List<FunctionName> functionNames = new ArrayList<FunctionName>();

    public static void main(String[] args) {
        SectionEditor.launchConfigurer(new FunctionNamespaceItem(), model -> {
            model.setManagedFunctionSourceClassName(ClassManagedFunctionSource.class.getName());
            model.addProperty(new PropertyModel("class.name", FunctionNamespaceItem.class.getName()));
            model.addManagedFunction(new ManagedFunctionModel("main"));
        });
    }

    public static FunctionNamespaceType loadFunctionNamespaceType(FunctionNamespaceItem item, OfficeFloorOsgiBridge osgiBridge) throws Exception {
        ManagedFunctionLoader loader = osgiBridge.getOfficeFloorCompiler().getManagedFunctionLoader();
        Class sourceClass = osgiBridge.loadClass(item.sourceClassName, ManagedFunctionSource.class);
        return loader.loadManagedFunctionType(sourceClass, item.properties);
    }

    public FunctionNamespaceModel prototype() {
        return new FunctionNamespaceModel("Functions", null);
    }

    public AbstractItem.IdeExtractor extract() {
        return new AbstractItem.IdeExtractor((AbstractItem)this, parent -> parent.getFunctionNamespaces(), (Enum[])new SectionModel.SectionEvent[]{SectionModel.SectionEvent.ADD_FUNCTION_NAMESPACE, SectionModel.SectionEvent.REMOVE_FUNCTION_NAMESPACE});
    }

    public void loadToParent(SectionModel parentModel, FunctionNamespaceModel itemModel) {
        parentModel.addFunctionNamespace(itemModel);
    }

    public Pane visual(FunctionNamespaceModel model, AdaptedChildVisualFactoryContext<FunctionNamespaceModel> context) {
        VBox container = new VBox();
        context.label((Pane)container).getStyleClass().add((Object)"title");
        context.addNode((Pane)container, (Node)((VBox)context.childGroup(ManagedFunctionItem.class.getSimpleName(), (Pane)new VBox())));
        return container;
    }

    public AbstractItem.IdeLabeller label() {
        return new AbstractItem.IdeLabeller((AbstractItem)this, model -> model.getFunctionNamespaceName(), (Enum[])new FunctionNamespaceModel.FunctionNamespaceEvent[]{FunctionNamespaceModel.FunctionNamespaceEvent.CHANGE_FUNCTION_NAMESPACE_NAME});
    }

    public String style() {
        AbstractItem.IdeStyle background = new AbstractItem.IdeStyle((AbstractItem)this).rule("-fx-background-color", "radial-gradient(radius 50.0%, blue, lightblue)");
        AbstractItem.IdeStyle text = new AbstractItem.IdeStyle((AbstractItem)this, ".${model} .title").rule("-fx-text-fill", "white");
        return String.valueOf(background.toString()) + text.toString();
    }

    protected FunctionNamespaceItem item(FunctionNamespaceModel model) {
        FunctionNamespaceItem item = new FunctionNamespaceItem();
        if (model != null) {
            item.name = model.getFunctionNamespaceName();
            item.sourceClassName = model.getManagedFunctionSourceClassName();
            if (ClassManagedFunctionSource.class.getName().equals(item.sourceClassName)) {
                item.choice = 0;
            }
            item.properties = this.translateToPropertyList(model.getProperties(), property -> property.getName(), property -> property.getValue());
            HashSet<String> existingFunctions = new HashSet<String>();
            for (ManagedFunctionModel managedFunction : model.getManagedFunctions()) {
                existingFunctions.add(managedFunction.getManagedFunctionName());
            }
            for (ManagedFunctionModel function : model.getManagedFunctions()) {
                String functionName = function.getManagedFunctionName();
                item.functionNames.add(new FunctionName(functionName, existingFunctions.contains(functionName)));
            }
        }
        return item;
    }

    public AbstractConfigurableItem.IdeConfigurer configure() {
        return new AbstractConfigurableItem.IdeConfigurer((AbstractConfigurableItem)this).addAndRefactor((builder, context) -> {
            builder.title("Functions");
            ((TextBuilder)((TextBuilder)builder.text("Name").init(item -> item.name)).validate(ValueValidator.notEmptyString((String)"Must specify name"))).setValue((item, value) -> {
                String string = item.name = value;
            });
            ChoiceBuilder choices = (ChoiceBuilder)((ChoiceBuilder)((ChoiceBuilder)builder.choices("").init(item -> item.choice)).validate(ValueValidator.notNull((String)"Must select"))).setValue((item, value) -> {
                if (value == 0) {
                    item.sourceClassName = ClassManagedFunctionSource.class.getName();
                }
            });
            ConfigurationBuilder classBuilder = choices.choice("Class");
            ((ClassBuilder)((ClassBuilder)classBuilder.clazz("Class").init(item -> item.properties.getOrAddProperty("class.name").getValue())).validate(ctx -> {
                FunctionNamespaceItem item = (FunctionNamespaceItem)((Object)((Object)((Object)ctx.getModel())));
                String className = item.properties.getOrAddProperty("class.name").getValue();
                ValueValidator.notEmptyString((String)className, (String)"Must specify class", (ValueValidator.ValueValidatorContext)ctx);
            })).setValue((item, value) -> item.properties.getOrAddProperty("class.name").setValue(value));
            ConfigurationBuilder sourceBuilder = choices.choice("Source");
            ((ClassBuilder)((ClassBuilder)sourceBuilder.clazz("Source").init(item -> item.sourceClassName)).superType(ManagedFunctionSource.class).validate(ValueValidator.notEmptyString((String)"Must specify source"))).setValue((item, value) -> {
                String string = item.sourceClassName = value;
            });
            ((PropertiesBuilder)sourceBuilder.properties("Properties").init(item -> item.properties)).setValue((item, value) -> {
                PropertyList propertyList = item.properties = value;
            });
            ListBuilder functionsBuilder = (ListBuilder)builder.list("Functions", FunctionName.class).init(item -> item.functionNames);
            functionsBuilder.text("Function").init(item -> ((FunctionName)item).name);
            ((FlagBuilder)functionsBuilder.flag("Include").init(item -> ((FunctionName)item).isUsed)).setValue((item, value) -> {
                boolean bl = value;
                boolean bl2 = bl;
                ((FunctionName)item).isUsed = bl;
            });
            builder.validate(ctx -> {
                OfficeFloorOsgiBridge osgiBridge = this.getConfigurableContext().getOsgiBridge();
                FunctionNamespaceItem item = (FunctionNamespaceItem)((Object)((Object)((Object)ctx.getModel())));
                item.functionNamespaceType = FunctionNamespaceItem.loadFunctionNamespaceType(item, osgiBridge);
                HashMap<String, FunctionName> existingNames = new HashMap<String, FunctionName>();
                for (FunctionName function : item.functionNames) {
                    existingNames.put(function.name, function);
                }
                item.functionNames = new ArrayList<FunctionName>();
                ManagedFunctionType[] managedFunctionTypeArray = item.functionNamespaceType.getManagedFunctionTypes();
                int n = managedFunctionTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ManagedFunctionType managedFunctionType = managedFunctionTypeArray[n2];
                    String functionName2 = managedFunctionType.getFunctionName();
                    FunctionName function = (FunctionName)existingNames.get(functionName2);
                    if (function == null) {
                        function = new FunctionName(functionName2, false);
                    }
                    item.functionNames.add(function);
                    ++n2;
                }
                ctx.reload((Builder)functionsBuilder);
                if (!item.functionNames.stream().anyMatch(functionName -> ((FunctionName)functionName).isUsed)) {
                    ctx.setError("Must select at least one function");
                }
            });
        }).add((builder, context) -> builder.apply("Add", item -> {
            ArrayList<String> functions = new ArrayList<String>(item.functionNames.size());
            for (FunctionName functionName : item.functionNames) {
                if (!functionName.isUsed) continue;
                functions.add(functionName.name);
            }
            context.execute(((SectionChanges)context.getOperations()).addFunctionNamespace(item.name, item.sourceClassName, item.properties, item.functionNamespaceType, functions.toArray(new String[functions.size()])));
        })).refactor((builder, context) -> builder.apply("Refactor", item -> {
            ArrayList<String> functions = new ArrayList<String>(item.functionNames.size());
            for (FunctionName functionName : item.functionNames) {
                if (!functionName.isUsed) continue;
                functions.add(functionName.name);
            }
            HashMap managedFunctionNameMapping = new HashMap();
            HashMap managedFunctionToObjectNameMapping = new HashMap();
            HashMap functionToFlowNameMapping = new HashMap();
            HashMap functionToEscalationTypeMapping = new HashMap();
            context.execute(((SectionChanges)context.getOperations()).refactorFunctionNamespace((FunctionNamespaceModel)context.getModel(), item.name, item.sourceClassName, item.properties, item.functionNamespaceType, managedFunctionNameMapping, managedFunctionToObjectNameMapping, functionToFlowNameMapping, functionToEscalationTypeMapping, functions.toArray(new String[functions.size()])));
        })).delete(context -> context.execute(((SectionChanges)context.getOperations()).removeFunctionNamespace((FunctionNamespaceModel)context.getModel())));
    }

    protected void children(List<AbstractItem.IdeChildrenGroup> children) {
        children.add(new AbstractItem.IdeChildrenGroup((AbstractItem)this, (AbstractItem)new ManagedFunctionItem()));
    }

    private static class FunctionName {
        private final String name;
        private boolean isUsed = false;

        private FunctionName(String name, boolean isUsed) {
            this.name = name;
            this.isUsed = isUsed;
        }
    }
}

