/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.docker.test;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.BuildImageResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.CreateNetworkResponse;
import com.github.dockerjava.api.command.PullImageResultCallback;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.api.model.Network;
import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.api.model.ResponseItem;
import com.github.dockerjava.core.DockerClientBuilder;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.officefloor.docker.test.DockerContainerInstance;
import net.officefloor.docker.test.DockerNetworkInstance;

public class OfficeFloorDockerUtil {
    private static final Set<String> pulledDockerImages = new HashSet<String>();

    public static DockerNetworkInstance ensureNetworkAvailable(String networkName) throws Exception {
        DockerClient docker = DockerClientBuilder.getInstance().build();
        for (Network network : (List)docker.listNetworksCmd().exec()) {
            if (!networkName.equals(network.getName())) continue;
            System.out.println("Docker network " + networkName + " available");
            return new DockerNetworkInstance(networkName, network.getId(), docker);
        }
        System.out.println("Creating docker network " + networkName);
        CreateNetworkResponse response = (CreateNetworkResponse)docker.createNetworkCmd().withName(networkName).exec();
        return new DockerNetworkInstance(networkName, response.getId(), docker);
    }

    public static void ensureImageAvailable(String imageName, BuildDirectoryFactory buildDirectoryFactory) throws Exception {
        try (DockerClient docker = DockerClientBuilder.getInstance().build();){
            for (Image image : (List)docker.listImagesCmd().withShowAll(Boolean.valueOf(true)).exec()) {
                String[] repoTags = image.getRepoTags();
                if (repoTags == null) continue;
                for (String tag : repoTags) {
                    if (!imageName.equals(tag)) continue;
                    return;
                }
            }
            File buildDir = buildDirectoryFactory.createBuildDirectory();
            System.out.println("Building image " + imageName + " from directory " + buildDir.getAbsolutePath());
            BuildImageResultCallback result = (BuildImageResultCallback)docker.buildImageCmd(buildDir).withTags(new HashSet<String>(Arrays.asList(imageName))).exec((ResultCallback)new BuildImageResultCallback(){

                public void onNext(BuildResponseItem item) {
                    String stream = item.getStream();
                    if (stream != null) {
                        System.out.print(stream);
                    }
                    super.onNext(item);
                }
            });
            result.awaitCompletion(10L, TimeUnit.MINUTES);
            System.out.println();
        }
    }

    public static DockerContainerInstance ensureContainerAvailable(String containerName, String imageName, Function<DockerClient, CreateContainerCmd> createContainer) throws Exception {
        DockerClient docker = DockerClientBuilder.getInstance().build();
        block0: for (Container container : (List)docker.listContainersCmd().withShowAll(Boolean.valueOf(true)).exec()) {
            for (String name : container.getNames()) {
                if (!name.equals("/" + containerName)) continue;
                String runningContainerImage = container.getImage();
                if (!imageName.equals(runningContainerImage)) {
                    throw new DockerException("Container " + containerName + " running image " + runningContainerImage + " (required to be " + imageName + ")", 500);
                }
                if (!"running".equals(container.getState())) {
                    docker.removeContainerCmd(container.getId()).exec();
                    continue block0;
                }
                System.out.println(containerName + " already running for " + imageName);
                return new DockerContainerInstance(containerName, imageName, container.getId(), docker);
            }
        }
        OfficeFloorDockerUtil.pullDockerImage(imageName, docker);
        System.out.println("Starting " + imageName + " as " + containerName);
        CreateContainerCmd createContainerCmd = createContainer.apply(docker);
        CreateContainerResponse createdContainer = createContainerCmd.exec();
        String containerId = createdContainer.getId();
        docker.startContainerCmd(containerId).exec();
        return new DockerContainerInstance(containerName, imageName, containerId, docker);
    }

    private static void pullDockerImage(String imageName, DockerClient docker) throws Exception {
        if (pulledDockerImages.contains(imageName)) {
            return;
        }
        try {
            System.out.println("Pulling image " + imageName);
            System.out.println();
            final int progressViewSize = 60;
            (docker.pullImageCmd(imageName).exec((ResultCallback)new PullImageResultCallback(){
                private final Map<String, Integer> items = new HashMap<String, Integer>();

                public void onNext(PullResponseItem item) {
                    ResponseItem.ProgressDetail progress = item.getProgressDetail();
                    if (progress != null && progress.getTotal() != null && progress.getCurrent() != null) {
                        long progressStart = progress.getStart() != null ? progress.getStart() : 0L;
                        long progressRange = progress.getTotal() - progressStart;
                        long progressValue = progress.getCurrent() - progressStart;
                        int progressViewCurrent = (int)((double)progressValue / (double)progressRange * (double)progressViewSize);
                        String id = item.getId();
                        Integer previousProgress = this.items.get(id);
                        if (previousProgress == null || !previousProgress.equals(progressViewCurrent)) {
                            int i;
                            this.items.put(id, progressViewCurrent);
                            StringBuilder entry = new StringBuilder();
                            entry.append(item.getStatus() + " ");
                            for (i = 0; i < progressViewCurrent; ++i) {
                                entry.append("=");
                            }
                            for (i = progressViewCurrent; i < progressViewSize; ++i) {
                                entry.append("-");
                            }
                            entry.append(" [" + progress.getCurrent() + "/" + progress.getTotal() + "]                           ");
                            System.out.println("\u001b[F\r" + entry.toString());
                        }
                    }
                    super.onNext(item);
                }
            })).awaitCompletion(10L, TimeUnit.MINUTES);
            System.out.print("\u001b[F\rComplete");
            for (int i = 0; i < progressViewSize * 2; ++i) {
                System.out.print(" ");
            }
            System.out.println();
        }
        catch (Exception ex) {
            List images = (List)docker.listImagesCmd().exec();
            boolean isImageExist = false;
            for (Image image : images) {
                if (image.getRepoTags() == null) continue;
                for (String tag : image.getRepoTags()) {
                    if (!imageName.equals(tag)) continue;
                    isImageExist = true;
                }
            }
            if (!isImageExist) {
                throw ex;
            }
            System.out.println("Using existing cached image " + imageName + ", as likely offline (error: " + ex.getMessage() + " - " + ex.getClass().getName() + ")");
        }
        pulledDockerImages.add(imageName);
    }

    @FunctionalInterface
    public static interface BuildDirectoryFactory {
        public File createBuildDirectory() throws Exception;
    }
}

