/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.docker.test;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.exception.ConflictException;
import com.github.dockerjava.api.model.Frame;
import java.io.Closeable;
import java.io.IOException;
import net.officefloor.docker.test.DockerConnectOperation;

public class DockerContainerInstance
implements AutoCloseable {
    private final String containerName;
    private final String imageName;
    private final String containerId;
    private final DockerClient docker;
    private boolean isClosed = false;

    public DockerContainerInstance(String containerName, String imageName, String containerId, DockerClient docker) {
        this.containerName = containerName;
        this.imageName = imageName;
        this.containerId = containerId;
        this.docker = docker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, T extends Throwable> R connectToDockerInstance(DockerConnectOperation<R, T> connect) throws T {
        try {
            return connect.connect();
        }
        catch (Throwable ex) {
            System.err.println("Failed to connect to Docker");
            final boolean[] isComplete = new boolean[]{false};
            this.docker.logContainerCmd(this.containerId).withStdOut(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true)).exec((ResultCallback)new ResultCallback<Frame>(){

                public void onStart(Closeable closeable) {
                }

                public void onNext(Frame frame) {
                    System.err.println(frame.toString());
                }

                public void onError(Throwable throwable) {
                    throwable.printStackTrace();
                    this.complete();
                }

                public void onComplete() {
                    this.complete();
                }

                public void close() throws IOException {
                    this.complete();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void complete() {
                    boolean[] blArray = isComplete;
                    synchronized (isComplete) {
                        isComplete[0] = true;
                        isComplete.notifyAll();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            long endTime = System.currentTimeMillis() + 60000L;
            boolean[] blArray = isComplete;
            synchronized (isComplete) {
                while (!isComplete[0]) {
                    if (System.currentTimeMillis() > endTime) {
                        throw new RuntimeException("Took too long to obtain Docker logs");
                    }
                    try {
                        isComplete.wait(10L);
                    }
                    catch (InterruptedException interrupted) {
                        isComplete[0] = true;
                    }
                }
                // ** MonitorExit[var6_5] (shouldn't be in output)
                throw ex;
            }
        }
    }

    @Override
    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        System.out.println("Stopping " + this.imageName + " as " + this.containerName);
        try {
            this.docker.killContainerCmd(this.containerId).exec();
        }
        catch (ConflictException ex) {
            System.out.println("Failed to stop docker container " + this.containerName + " (image " + this.imageName + "): " + ex.getMessage());
        }
        this.docker.removeContainerCmd(this.containerId).exec();
        try {
            this.docker.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

