/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.docker.test;

import com.github.dockerjava.api.DockerClient;
import java.io.IOException;

public class DockerNetworkInstance
implements AutoCloseable {
    private final String networkName;
    private final String networkId;
    private final DockerClient docker;
    private boolean isClosed = false;

    public DockerNetworkInstance(String networkName, String networkId, DockerClient docker) {
        this.networkName = networkName;
        this.networkId = networkId;
        this.docker = docker;
    }

    @Override
    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        System.out.println("Removing docker network " + this.networkName);
        this.docker.removeNetworkCmd(this.networkId).exec();
        try {
            this.docker.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

