/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.docker.test;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.CreateNetworkResponse;
import com.github.dockerjava.api.command.PullImageResultCallback;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.api.model.Network;
import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.core.DockerClientBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.officefloor.docker.test.DockerContainerInstance;
import net.officefloor.docker.test.DockerNetworkInstance;

public class OfficeFloorDockerUtil {
    private static final Set<String> pulledDockerImages = new HashSet<String>();

    public static DockerNetworkInstance ensureNetworkAvailable(String networkName) throws Exception {
        DockerClient docker = DockerClientBuilder.getInstance().build();
        for (Network network : (List)docker.listNetworksCmd().exec()) {
            if (!networkName.equals(network.getName())) continue;
            System.out.println("Docker network " + networkName + " available");
            return new DockerNetworkInstance(networkName, network.getId(), docker);
        }
        System.out.println("Creating docker network " + networkName);
        CreateNetworkResponse response = (CreateNetworkResponse)docker.createNetworkCmd().withName(networkName).exec();
        return new DockerNetworkInstance(networkName, response.getId(), docker);
    }

    public static DockerContainerInstance ensureContainerAvailable(String containerName, String imageName, Function<DockerClient, CreateContainerCmd> createContainer) throws Exception {
        DockerClient docker = DockerClientBuilder.getInstance().build();
        block0: for (Container container : (List)docker.listContainersCmd().withShowAll(Boolean.valueOf(true)).exec()) {
            for (String name : container.getNames()) {
                if (!name.equals("/" + containerName)) continue;
                String runningContainerImage = container.getImage();
                if (!imageName.equals(runningContainerImage)) {
                    throw new DockerException("Container " + containerName + " running image " + runningContainerImage + " (required to be " + imageName + ")", 500);
                }
                if (!"running".equals(container.getState())) {
                    docker.removeContainerCmd(container.getId()).exec();
                    continue block0;
                }
                System.out.println(containerName + " already running for " + imageName);
                return new DockerContainerInstance(containerName, imageName, container.getId(), docker);
            }
        }
        OfficeFloorDockerUtil.pullDockerImage(imageName, docker);
        System.out.println("Starting " + imageName + " as " + containerName);
        CreateContainerCmd createContainerCmd = createContainer.apply(docker);
        CreateContainerResponse createdContainer = createContainerCmd.exec();
        String containerId = createdContainer.getId();
        docker.startContainerCmd(containerId).exec();
        return new DockerContainerInstance(containerName, imageName, containerId, docker);
    }

    private static void pullDockerImage(String imageName, DockerClient docker) throws Exception {
        if (pulledDockerImages.contains(imageName)) {
            return;
        }
        try {
            (docker.pullImageCmd(imageName).exec((ResultCallback)new PullImageResultCallback(){

                public void onNext(PullResponseItem item) {
                    if (item.getProgressDetail() != null) {
                        System.out.println(item.getProgressDetail());
                    }
                    super.onNext(item);
                }
            })).awaitCompletion(10L, TimeUnit.MINUTES);
        }
        catch (Exception ex) {
            List images = (List)docker.listImagesCmd().exec();
            boolean isImageExist = false;
            for (Image image : images) {
                if (image.getRepoTags() == null) continue;
                for (String tag : image.getRepoTags()) {
                    if (!imageName.equals(tag)) continue;
                    isImageExist = true;
                }
            }
            if (!isImageExist) {
                throw ex;
            }
            System.out.println("Using existing cached image " + imageName + ", as likely offline (error: " + ex.getMessage() + " - " + ex.getClass().getName() + ")");
        }
        pulledDockerImages.add(imageName);
    }
}

