/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.docker.test;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.exception.ConflictException;
import java.io.IOException;

public class DockerContainerInstance
implements AutoCloseable {
    private final String containerName;
    private final String imageName;
    private final String containerId;
    private final DockerClient docker;
    private boolean isClosed = false;

    public DockerContainerInstance(String containerName, String imageName, String containerId, DockerClient docker) {
        this.containerName = containerName;
        this.imageName = imageName;
        this.containerId = containerId;
        this.docker = docker;
    }

    @Override
    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        System.out.println("Stopping " + this.imageName + " as " + this.containerName);
        try {
            this.docker.killContainerCmd(this.containerId).exec();
        }
        catch (ConflictException ex) {
            System.out.println("Failed to stop docker container " + this.containerName + " (image " + this.imageName + "): " + ex.getMessage());
        }
        this.docker.removeContainerCmd(this.containerId).exec();
        try {
            this.docker.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

