/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.cache.constant;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import net.officefloor.cache.Cache;
import net.officefloor.cache.constant.ConstantCacheDataRetriever;
import net.officefloor.frame.api.build.None;
import net.officefloor.frame.api.clock.Clock;
import net.officefloor.frame.api.managedobject.ManagedObject;
import net.officefloor.frame.api.managedobject.source.ManagedObjectExecuteContext;
import net.officefloor.frame.api.managedobject.source.ManagedObjectFunctionBuilder;
import net.officefloor.frame.api.managedobject.source.ManagedObjectFunctionDependency;
import net.officefloor.frame.api.managedobject.source.ManagedObjectSourceContext;
import net.officefloor.frame.api.managedobject.source.impl.AbstractAsyncManagedObjectSource;
import net.officefloor.frame.api.managedobject.source.impl.AbstractManagedObjectSource;
import net.officefloor.plugin.managedobject.poll.StatePollContext;
import net.officefloor.plugin.managedobject.poll.StatePoller;

public class ConstantCacheManagedObjectSource<K, V>
extends AbstractManagedObjectSource<None, Flows>
implements ManagedObject {
    public static final String POLL_INTERVAL = "poll.interval";
    public static final String DATA_RETRIEVER_QUALIFIER = "qualifier";
    private Logger logger;
    private Clock<Long> clock;
    private Long pollIntervalMilliseconds = null;
    private StatePoller<Map<K, V>, Flows> state;
    private final Cache<K, V> cache = key -> {
        try {
            return ((Map)this.state.getState(this.pollIntervalMilliseconds != null ? this.pollIntervalMilliseconds : 1000L, TimeUnit.MILLISECONDS)).get(key);
        }
        catch (TimeoutException ex) {
            this.logger.warning("Timed out obtaining cached data");
            return null;
        }
    };

    public Cache<K, V> getCache() {
        return this.cache;
    }

    protected void loadSpecification(AbstractAsyncManagedObjectSource.SpecificationContext context) {
    }

    protected void loadMetaData(AbstractAsyncManagedObjectSource.MetaDataContext<None, Flows> context) throws Exception {
        ManagedObjectSourceContext mosContext = context.getManagedObjectSourceContext();
        this.logger = mosContext.getLogger();
        String pollInterval = mosContext.getProperty(POLL_INTERVAL, null);
        if (pollInterval != null) {
            this.pollIntervalMilliseconds = Long.valueOf(pollInterval);
        }
        String qualifier = mosContext.getProperty(DATA_RETRIEVER_QUALIFIER, null);
        context.setObjectClass(Cache.class);
        this.clock = mosContext.getClock(time -> time);
        String FUNCTION_NAME = "REFRESH";
        ManagedObjectFunctionBuilder function = mosContext.addManagedFunction("REFRESH", () -> functionContext -> {
            StatePollContext pollContext = (StatePollContext)functionContext.getObject(0);
            ConstantCacheDataRetriever retriever = (ConstantCacheDataRetriever)functionContext.getObject(1);
            Map data = retriever.getData();
            HashMap cacheData = new HashMap(data);
            pollContext.setNextState(cacheData, -1L, null);
        });
        function.linkParameter(0, StatePollContext.class);
        ManagedObjectFunctionDependency retriever = mosContext.addFunctionDependency("RETRIEVER", ConstantCacheDataRetriever.class);
        if (qualifier != null) {
            retriever.setTypeQualifier(qualifier);
        }
        function.linkObject(1, retriever);
        mosContext.getFlow((Enum)Flows.REFRESH).linkFunction("REFRESH");
        context.addFlow((Enum)Flows.REFRESH, null);
    }

    public void start(ManagedObjectExecuteContext<Flows> context) throws Exception {
        StatePoller.Builder builder = StatePoller.builder(Map.class, this.clock, (Enum)Flows.REFRESH, context, pollContext -> this).parameter(pollContext -> pollContext);
        if (this.pollIntervalMilliseconds != null) {
            builder.defaultPollInterval(this.pollIntervalMilliseconds.longValue(), TimeUnit.MILLISECONDS);
        }
        this.state = builder.build();
    }

    protected ManagedObject getManagedObject() throws Throwable {
        return this;
    }

    public Object getObject() throws Throwable {
        return this.cache;
    }

    public static enum Flows {
        REFRESH;

    }
}

