/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.cabinet.dynamo;

import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.document.TableKeysAndAttributes;
import com.amazonaws.services.dynamodbv2.document.TableWriteItems;
import com.amazonaws.services.dynamodbv2.document.spec.BatchGetItemSpec;
import com.amazonaws.services.dynamodbv2.document.spec.BatchWriteItemSpec;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.officefloor.cabinet.Key;
import net.officefloor.cabinet.OfficeCabinet;
import net.officefloor.cabinet.common.CabinetUtil;
import net.officefloor.test.UsesDockerTest;

@UsesDockerTest
public class DynamoOfficeCabinet<D>
implements OfficeCabinet<D> {
    private static final Map<Class<?>, AttributeType<?>> fieldTypeToAtributeType = new HashMap();
    private final DynamoDB dynamoDb;
    private final ItemMetaData<D> itemMetaData;

    public DynamoOfficeCabinet(Class<D> documentType, DynamoDB dynamoDb) throws Exception {
        this.dynamoDb = dynamoDb;
        String tableName = CabinetUtil.getDocumentName(documentType);
        LinkedList<AttributeDefinition> attributeDefinitions = new LinkedList<AttributeDefinition>();
        LinkedList<KeySchemaElement> keys = new LinkedList<KeySchemaElement>();
        Attribute keyAttribute = null;
        ArrayList attributes = new ArrayList();
        Class<D> interrogate = documentType;
        do {
            for (Field field : interrogate.getDeclaredFields()) {
                field.setAccessible(true);
                String attributeName = field.getName();
                Class<?> attributeClass = field.getType();
                AttributeType<?> attributeType = fieldTypeToAtributeType.get(attributeClass);
                if (attributeType == null) {
                    throw new UnsupportedOperationException("TODO implement embedded for " + attributeName + " of type " + attributeClass.getName());
                }
                Attribute attribute = new Attribute(field, attributeType);
                Key key = field.getAnnotation(Key.class);
                if (key != null) {
                    keys.add(new KeySchemaElement(attributeName, KeyType.HASH));
                    attributeDefinitions.add(new AttributeDefinition(attributeName, attributeType.attributeType));
                    keyAttribute = attribute;
                    continue;
                }
                attributes.add(attribute);
            }
        } while ((interrogate = interrogate.getSuperclass()) != null);
        this.itemMetaData = new ItemMetaData<D>(documentType, tableName, keyAttribute, attributes);
        ProvisionedThroughput provisionedThroughput = new ProvisionedThroughput(Long.valueOf(25L), Long.valueOf(25L));
        CreateTableRequest createTable = new CreateTableRequest(attributeDefinitions, tableName, keys, provisionedThroughput);
        Table table = this.dynamoDb.createTable(createTable);
        table.waitForActive();
    }

    public Optional<D> retrieveByKey(String key) {
        TableKeysAndAttributes tableKey = new TableKeysAndAttributes(this.itemMetaData.tableName).addHashOnlyPrimaryKey(this.itemMetaData.key.field.getName(), (Object)key);
        BatchGetItemSpec get = new BatchGetItemSpec().withTableKeyAndAttributes(new TableKeysAndAttributes[]{tableKey});
        List items = (List)this.dynamoDb.batchGetItem(get).getTableItems().get(this.itemMetaData.tableName);
        if (items.size() == 0) {
            return Optional.empty();
        }
        Item item = (Item)items.get(0);
        try {
            Object document = this.itemMetaData.documentType.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.itemMetaData.key.field.set(document, this.itemMetaData.key.attributeType.getter.get(item, this.itemMetaData.key.field.getName()));
            for (Attribute<?> attribute : this.itemMetaData.attributes) {
                attribute.field.set(document, attribute.attributeType.getter.get(item, attribute.field.getName()));
            }
            return Optional.of(document);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to retrieve document " + this.itemMetaData.documentType.getName(), ex);
        }
    }

    public void store(D document) {
        BatchWriteItemSpec write = new BatchWriteItemSpec();
        try {
            String key = (String)this.itemMetaData.key.field.get(document);
            if (key == null) {
                key = CabinetUtil.newKey();
                this.itemMetaData.key.field.set(document, key);
            }
            Item item = new Item();
            item.withPrimaryKey(this.itemMetaData.key.field.getName(), (Object)key);
            for (Attribute<?> attribute : this.itemMetaData.attributes) {
                attribute.attributeType.setter.set(item, attribute.field.getName(), attribute.field.get(document));
            }
            System.out.println("ITEM: " + item);
            TableWriteItems items = new TableWriteItems(this.itemMetaData.tableName);
            items.addItemToPut(item);
            write.withTableWriteItems(new TableWriteItems[]{items});
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to store document " + document.getClass().getName(), ex);
        }
        this.dynamoDb.batchWriteItem(write);
    }

    static {
        String numberType = ScalarAttributeType.N.name();
        fieldTypeToAtributeType.put(Boolean.TYPE, new AttributeType<Boolean>(numberType, Item::getBoolean, Item::withBoolean));
        fieldTypeToAtributeType.put(Byte.TYPE, new AttributeType<Byte>(numberType, (item, attributeName) -> item.getBinary(attributeName)[0], (item, attributeName, value) -> item.withBinary(attributeName, new byte[]{value})));
        fieldTypeToAtributeType.put(Short.TYPE, new AttributeType<Short>(numberType, Item::getShort, Item::withShort));
        fieldTypeToAtributeType.put(Integer.TYPE, new AttributeType<Integer>(numberType, Item::getInt, Item::withInt));
        fieldTypeToAtributeType.put(Long.TYPE, new AttributeType<Long>(numberType, Item::getLong, Item::withLong));
        fieldTypeToAtributeType.put(Float.TYPE, new AttributeType<Float>(numberType, Item::getFloat, Item::withFloat));
        fieldTypeToAtributeType.put(Double.TYPE, new AttributeType<Double>(numberType, Item::getDouble, Item::withDouble));
        String stringType = ScalarAttributeType.S.name();
        fieldTypeToAtributeType.put(Character.TYPE, new AttributeType<Character>(stringType, (item, attributeName) -> Character.valueOf(item.getString(attributeName).charAt(0)), (item, attributeName, value) -> item.withString(attributeName, new String(new char[]{value.charValue()}))));
        fieldTypeToAtributeType.put(String.class, new AttributeType<String>(stringType, Item::getString, Item::withString));
    }

    private static class ItemMetaData<D> {
        private final Class<D> documentType;
        private final String tableName;
        private final Attribute<String> key;
        private final List<Attribute<?>> attributes;

        private ItemMetaData(Class<D> documentType, String tableName, Attribute<String> key, List<Attribute<?>> attributes) {
            this.documentType = documentType;
            this.tableName = tableName;
            this.key = key;
            this.attributes = attributes;
        }
    }

    private static class Attribute<T> {
        private final Field field;
        private final AttributeType<T> attributeType;

        private Attribute(Field field, AttributeType<T> attributeType) {
            this.field = field;
            this.attributeType = attributeType;
        }
    }

    private static class AttributeType<T> {
        private final String attributeType;
        private final AttributeGetter<T> getter;
        private final AttributeSetter<T> setter;

        private AttributeType(String attributeType, AttributeGetter<T> getter, AttributeSetter<T> setter) {
            this.attributeType = attributeType;
            this.getter = getter;
            this.setter = setter;
        }
    }

    @FunctionalInterface
    private static interface AttributeSetter<T> {
        public void set(Item var1, String var2, T var3);
    }

    @FunctionalInterface
    private static interface AttributeGetter<T> {
        public T get(Item var1, String var2);
    }
}

