/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.cabinet.cosmosdb;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.CosmosDatabase;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.CosmosItemRequestOptions;
import com.azure.cosmos.models.CosmosItemResponse;
import com.azure.cosmos.models.IncludedPath;
import com.azure.cosmos.models.IndexingPolicy;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.PartitionKeyDefinition;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import net.officefloor.cabinet.Key;
import net.officefloor.cabinet.OfficeCabinet;
import net.officefloor.cabinet.common.CabinetUtil;

public class CosmosOfficeCabinet<D>
implements OfficeCabinet<D> {
    private final CosmosContainer container;
    private final Class<D> documentType;
    private final Field keyField;

    public CosmosOfficeCabinet(Class<D> documentType, CosmosDatabase cosmosDatabase) throws Exception {
        this.documentType = documentType;
        String containerId = CabinetUtil.getDocumentName(documentType);
        Field keyField = null;
        Class<D> interrogate = documentType;
        do {
            for (Field field : interrogate.getDeclaredFields()) {
                Key key = field.getAnnotation(Key.class);
                if (key == null) continue;
                if (keyField != null) {
                    throw new IllegalStateException("More than one " + Key.class.getSimpleName() + " (" + keyField.getName() + ", " + field.getName() + ") on class " + documentType.getName());
                }
                keyField = field;
            }
        } while ((interrogate = interrogate.getSuperclass()) != null);
        this.keyField = keyField;
        this.keyField.setAccessible(true);
        CosmosContainerProperties createContainer = new CosmosContainerProperties(containerId, new PartitionKeyDefinition().setPaths(Arrays.asList("/" + keyField.getName())));
        createContainer.setIndexingPolicy(new IndexingPolicy().setIncludedPaths(Arrays.asList(new IncludedPath("/booleanPrimitive"))));
        cosmosDatabase.createContainer(createContainer);
        this.container = cosmosDatabase.getContainer(documentType.getSimpleName());
    }

    public Optional<D> retrieveByKey(String key) {
        CosmosItemRequestOptions options = new CosmosItemRequestOptions().setConsistencyLevel(ConsistencyLevel.STRONG);
        CosmosItemResponse response = this.container.readItem(key, new PartitionKey((Object)key), options, this.documentType);
        return Optional.of(response.getItem());
    }

    public void store(D document) {
        String key;
        boolean isNew = false;
        try {
            key = (String)this.keyField.get(document);
            if (key == null) {
                key = CabinetUtil.newKey();
                this.keyField.set(document, key);
                isNew = true;
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to store document " + document.getClass().getName(), ex);
        }
        if (isNew) {
            this.container.createItem(document);
        } else {
            this.container.replaceItem(document, key, new PartitionKey((Object)key), null);
        }
    }
}

