/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.awslambda.web;

import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.odoframework.awslambda.web.CognitoPrincipal;
import net.odoframework.container.util.Json;
import net.odoframework.service.web.URNPath;
import net.odoframework.service.web.WebRequest;
import net.odoframework.util.Strings;

public class ApiGatewayV2Request
implements WebRequest {
    private Json json;
    private Map<String, String> pathVariables;
    private Map<String, ?> request;

    public ApiGatewayV2Request(Json json, Map<String, Object> request) {
        this.json = Objects.requireNonNull(json);
        this.request = Objects.requireNonNull(request);
    }

    public String getBody() {
        String body = (String)this.request.get("body");
        if (Strings.isNotBlank((String)body) && this.isBase64Encoded()) {
            body = new String(Base64.getDecoder().decode(body), StandardCharsets.UTF_8);
        }
        return body;
    }

    public <T> T getBody(Class<T> type) {
        String body = this.getBody();
        if (body != null) {
            return (T)this.getJson().unmarshal(body, type);
        }
        return null;
    }

    private boolean isBase64Encoded() {
        Object isBase64Encoded = this.request.get("isBase64Encoded");
        if (isBase64Encoded == null) {
            return false;
        }
        return (Boolean)isBase64Encoded;
    }

    public Optional<List<String>> getMultiValueHeader(String name) {
        return Optional.empty();
    }

    public Optional<Principal> getUserPrincipal() {
        return Optional.of(new CognitoPrincipal((Map)this.getRequestContext().get("principal")));
    }

    public Map<String, ?> getRequestContext() {
        return (Map)this.request.get("requestContext");
    }

    public Optional<String> getHeader(String name) {
        return Optional.ofNullable(this.getHeaders().get(name));
    }

    public String getPath() {
        return (String)this.request.get("path");
    }

    private Map<String, String> getHeaders() {
        return (Map)this.request.get("headers");
    }

    public Optional<String> getPathVariable(String name) {
        if (this.pathVariablesNotSet()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.pathVariables.get(name));
    }

    public String getMethod() {
        return (String)this.request.get("httpMethod");
    }

    public boolean matches(String pattern) {
        Optional pathVariables = URNPath.match((String)this.getPath(), (String)pattern);
        if (this.pathVariablesNotSet() && pathVariables.isPresent()) {
            this.pathVariables = (Map)pathVariables.get();
            return true;
        }
        return false;
    }

    public boolean pathVariablesNotSet() {
        return this.pathVariables == null || this.pathVariables.isEmpty();
    }

    public Optional<String> getQueryParam(String name) {
        return Optional.ofNullable(this.getQueryParameters().get(name));
    }

    private Map<String, String> getQueryParameters() {
        return (Map)this.request.get("queryStringParameters");
    }

    public Optional<List<String>> getMultiValueQueryParam(String name) {
        return Optional.ofNullable(this.getMultiValueQueryParameters().get(name));
    }

    private Map<String, List<String>> getMultiValueQueryParameters() {
        return (Map)this.request.get("multiValueQueryStringParameters");
    }

    public Json getJson() {
        return this.json;
    }

    void setJson(Json json) {
        this.json = json;
    }

    public Map<String, String> getPathVariables() {
        return this.pathVariables;
    }

    public Map<String, ?> getRequest() {
        return this.request;
    }

    public void setPathVariables(Map<String, String> pathVariables) {
        this.pathVariables = pathVariables;
    }

    public void setRequest(Map<String, ?> request) {
        this.request = request;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiGatewayV2Request)) {
            return false;
        }
        ApiGatewayV2Request other = (ApiGatewayV2Request)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Json this$json = this.getJson();
        Json other$json = other.getJson();
        if (this$json == null ? other$json != null : !this$json.equals(other$json)) {
            return false;
        }
        Map<String, String> this$pathVariables = this.getPathVariables();
        Map<String, String> other$pathVariables = other.getPathVariables();
        if (this$pathVariables == null ? other$pathVariables != null : !((Object)this$pathVariables).equals(other$pathVariables)) {
            return false;
        }
        Map<String, ?> this$request = this.getRequest();
        Map<String, ?> other$request = other.getRequest();
        return !(this$request == null ? other$request != null : !((Object)this$request).equals(other$request));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiGatewayV2Request;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Json $json = this.getJson();
        result = result * 59 + ($json == null ? 43 : $json.hashCode());
        Map<String, String> $pathVariables = this.getPathVariables();
        result = result * 59 + ($pathVariables == null ? 43 : ((Object)$pathVariables).hashCode());
        Map<String, ?> $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
        return result;
    }

    public String toString() {
        return "ApiGatewayV2Request(json=" + this.getJson() + ", pathVariables=" + this.getPathVariables() + ", request=" + this.getRequest() + ")";
    }
}

