/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.awslambda.logging;

import com.amazonaws.services.lambda.runtime.LambdaRuntime;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.function.Consumer;
import net.odoframework.awslambda.util.InvocationContext;
import net.odoframework.container.events.Log;
import net.odoframework.util.Exceptions;
import net.odoframework.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AWSLogFormatter
implements Consumer<Log> {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ").withZone(ZoneId.systemDefault());
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private boolean json = true;

    public AWSLogFormatter(boolean json) {
        this.json = json;
    }

    String format(Log log) {
        if (this.json) {
            return this.formatJson(log);
        }
        return this.formatLine(log);
    }

    public String formatLine(Log log) {
        String line = String.join((CharSequence)" ", DATE_TIME_FORMATTER.format(log.getTimestamp()), InvocationContext.getInvocationId(), log.getLevel().getUpperCaseName(), log.getMessageAsString());
        if (log.getError() != null) {
            return String.join((CharSequence)"\n", line, Exceptions.toString((Throwable)Exceptions.getRoot((Throwable)log.getError())));
        }
        return line;
    }

    private String formatJson(Log log) {
        JsonObject object = new JsonObject();
        object.add("id", (JsonElement)new JsonPrimitive(InvocationContext.getInvocationId()));
        if (Strings.isBlank((String)log.getLoggerName())) {
            object.add("name", (JsonElement)new JsonPrimitive(log.getLoggerName()));
        }
        object.add("level", (JsonElement)new JsonPrimitive(log.getLevel().getUpperCaseName()));
        object.add("message", (JsonElement)new JsonPrimitive(log.getMessageAsString()));
        object.add("timestamp", (JsonElement)new JsonPrimitive(DATE_TIME_FORMATTER.format(log.getTimestamp())));
        if (log.getError() != null) {
            object.add("error", (JsonElement)new JsonPrimitive(Exceptions.toString((Throwable)Exceptions.getRoot((Throwable)log.getError()))));
        }
        return GSON.toJson((JsonElement)object);
    }

    @Override
    public void accept(Log log) {
        Logger logger = LoggerFactory.getLogger((String)log.getLoggerName());
        if (log.getLevel() == Log.Level.trace && logger.isTraceEnabled()) {
            LambdaRuntime.getLogger().log(this.format(log) + "\n");
        }
        if (log.getLevel() == Log.Level.debug && logger.isDebugEnabled()) {
            LambdaRuntime.getLogger().log(this.format(log) + "\n");
        }
        if (log.getLevel() == Log.Level.info && logger.isInfoEnabled()) {
            LambdaRuntime.getLogger().log(this.format(log) + "\n");
        }
        if (log.getLevel() == Log.Level.error && logger.isErrorEnabled()) {
            LambdaRuntime.getLogger().log(this.format(log) + "\n");
        }
        if (log.getLevel() == Log.Level.warn && logger.isWarnEnabled()) {
            LambdaRuntime.getLogger().log(this.format(log) + "\n");
        }
    }
}

