/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.awslambda;

import com.amazonaws.services.lambda.runtime.Context;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import net.odoframework.awslambda.web.ApiGatewayV2Request;
import net.odoframework.container.util.Json;
import net.odoframework.service.InvocationContext;
import net.odoframework.service.RequestConverter;
import net.odoframework.service.web.WebFunction;

public class DefaultRequestConverter
implements RequestConverter<Object, Object, Context> {
    private BiFunction<?, ?, ?> handler;
    private Json json;

    public DefaultRequestConverter(BiFunction<?, ?, ?> handler, Json json) {
        this.handler = Objects.requireNonNull(handler, "handler is required");
        this.json = Objects.requireNonNull(json);
    }

    public Object decode(Object format, InvocationContext<Context> context) {
        if (this.handler instanceof WebFunction) {
            Map payload = null;
            payload = format instanceof String ? this.json.unmarshalToMap(format.toString()) : (Map)format;
            return new ApiGatewayV2Request(this.json, payload);
        }
        return format;
    }
}

