/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.awslambda.web;

import java.security.Principal;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.security.auth.Subject;

public class CognitoPrincipal
implements Principal {
    private Map<String, ?> cognitoDetails;

    public CognitoPrincipal(Map<String, ?> cognitoDetails) {
        this.cognitoDetails = Objects.requireNonNull(cognitoDetails, "required identity map");
    }

    @Override
    public String getName() {
        return this.getUser();
    }

    public String getUser() {
        return (String)this.cognitoDetails.get("user");
    }

    public String getCognitoIdentityPoolId() {
        return (String)this.cognitoDetails.get("cognitoIdentityPoolId");
    }

    public String getAccountId() {
        return (String)this.cognitoDetails.get("accountId");
    }

    public String getCognitoIdentityId() {
        return (String)this.cognitoDetails.get("cognitoIdentityId");
    }

    public String getCaller() {
        return (String)this.cognitoDetails.get("caller");
    }

    public String getApiKey() {
        return (String)this.cognitoDetails.get("apiKey");
    }

    public String getSourceIp() {
        return (String)this.cognitoDetails.get("sourceIp");
    }

    public String getCognitoAuthenticationType() {
        return (String)this.cognitoDetails.get("cognitoAuthenticationType");
    }

    public String getCognitoAuthenticationProvider() {
        return (String)this.cognitoDetails.get("cognitoAuthenticationProvider");
    }

    public String getUserArn() {
        return (String)this.cognitoDetails.get("userArn");
    }

    public String getUserAgent() {
        return (String)this.cognitoDetails.get("userAgent");
    }

    public String getAccessKey() {
        return (String)this.cognitoDetails.get("accessKey");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CognitoPrincipal)) {
            return false;
        }
        CognitoPrincipal that = (CognitoPrincipal)o;
        return this.cognitoDetails.equals(that.cognitoDetails);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.cognitoDetails);
    }

    @Override
    public boolean implies(Subject subject) {
        return Optional.ofNullable(subject.getPrincipals(CognitoPrincipal.class)).map(this::equals).orElse(false);
    }
}

