/*
 * Decompiled with CFR 0.152.
 */
package net.octyl.elivi.asm;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import net.octyl.elivi.CodeCompressor;
import net.octyl.elivi.CompressOption;
import net.octyl.elivi.asm.CompressingClassVisitor;
import net.octyl.elivi.asm.RemapBuilder;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.SimpleRemapper;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a8\u0006\u000f"}, d2={"Lnet/octyl/elivi/asm/AsmCodeCompressor;", "Lnet/octyl/elivi/CodeCompressor;", "()V", "compress", "", "source", "Ljava/nio/file/Path;", "dest", "flags", "", "Lnet/octyl/elivi/CompressOption;", "doCompress", "", "input", "Ljava/io/InputStream;", "elivi-code-compressor"})
public final class AsmCodeCompressor
implements CodeCompressor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compress(@NotNull Path source, @NotNull Path dest, @NotNull Set<? extends CompressOption> flags) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
        Intrinsics.checkParameterIsNotNull(flags, (String)"flags");
        Closeable closeable = Files.newInputStream(source, new OpenOption[0]);
        boolean bl = false;
        Throwable throwable = null;
        try {
            InputStream input = (InputStream)closeable;
            boolean bl2 = false;
            InputStream inputStream = input;
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"input");
            byArray = this.doCompress(inputStream, flags);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] classData = byArray;
        Files.write(dest, classData, new OpenOption[0]);
    }

    private final byte[] doCompress(InputStream input, Set<? extends CompressOption> flags) {
        ClassReader reader = new ClassReader(input);
        ClassWriter writer = new ClassWriter(0);
        RemapBuilder remapper = new RemapBuilder(flags);
        reader.accept((ClassVisitor)remapper, 7);
        reader.accept((ClassVisitor)new ClassRemapper((ClassVisitor)new CompressingClassVisitor(flags, (ClassVisitor)writer), (Remapper)new SimpleRemapper(remapper.getMap())), 0);
        byte[] byArray = writer.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"writer.toByteArray()");
        return byArray;
    }
}

