/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.util.print;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.TimingSessionContainer;
import net.obvj.performetrics.util.Duration;
import net.obvj.performetrics.util.DurationFormat;
import net.obvj.performetrics.util.print.PrintStyle;

public enum PrintFormat {
    SUMMARIZED{

        @Override
        public String format(TimingSessionContainer container, PrintStyle style) {
            this.checkCompatibility(style);
            StringBuilder builder = new StringBuilder();
            1.appendLine(builder, style.getAlternativeLine());
            if (style.isPrintHeader()) {
                1.appendLine(builder, style.getHeaderFormat(), PrintFormat.HEADER_COUNTER, PrintFormat.HEADER_ELAPSED_TIME);
                1.appendLine(builder, style.getSimpleLine());
            }
            container.getTypes().stream().filter(style::isPrintable).forEach(type -> 1.appendLine(builder, this.toRowFormat(container, (Counter.Type)((Object)type), style)));
            if (style.isPrintTrailer()) {
                1.appendLine(builder, style.getSimpleLine());
                1.appendLine(builder, style.getTrailerFormat(), PrintFormat.HEADER_COUNTER, PrintFormat.HEADER_ELAPSED_TIME);
            }
            1.appendLine(builder, style.getAlternativeLine());
            return builder.toString();
        }

        private String toRowFormat(TimingSessionContainer stopwatch, Counter.Type type, PrintStyle style) {
            return String.format(style.getRowFormat(), style.getPrintableCounterName(type), style.getDurationFormat().format(stopwatch.elapsedTime(type), style.isPrintLegend()));
        }
    }
    ,
    DETAILED{

        @Override
        public String format(TimingSessionContainer container, PrintStyle style) {
            this.checkCompatibility(style);
            StringBuilder builder = new StringBuilder();
            if (style.isPrintHeader()) {
                2.appendLine(builder, style.getAlternativeLine());
                2.appendLine(builder, style.getHeaderFormat(), PrintFormat.HEADER_SESSION, PrintFormat.HEADER_ELAPSED_TIME, PrintFormat.HEADER_ELAPSED_TIME_ACC, PrintFormat.HEADER_COUNTER);
            }
            Map<Counter.Type, List<Counter>> countersByType = container.getAllCountersByType();
            countersByType.forEach((type, counters) -> {
                if (!style.isPrintable((Counter.Type)((Object)type))) {
                    return;
                }
                2.appendLine(builder, style.getAlternativeLine());
                2.appendLine(builder, style.getSectionHeaderFormat(), style.getPrintableCounterName((Counter.Type)((Object)type)));
                2.appendLine(builder, style.getSimpleLine());
                Duration elapsedTimeAcc = Duration.ZERO;
                for (int sequence = 0; sequence < counters.size(); ++sequence) {
                    Counter counter = (Counter)counters.get(sequence);
                    Duration elapsedTime = counter.elapsedTime();
                    elapsedTimeAcc = elapsedTimeAcc.plus(elapsedTime);
                    2.appendLine(builder, this.toRowFormat(sequence, elapsedTime, elapsedTimeAcc, style, (Counter.Type)((Object)type)));
                }
                if (style.isPrintSectionSummary()) {
                    2.appendLine(builder, style.getSimpleLine());
                    2.appendLine(builder, this.toTotalRowFormat(elapsedTimeAcc, style));
                }
                if (style.isPrintSectionTrailer()) {
                    2.appendLine(builder, style.getSimpleLine());
                    2.appendLine(builder, style.getSectionTrailerFormat(), style.getPrintableCounterName((Counter.Type)((Object)type)));
                }
            });
            if (style.isPrintTrailer()) {
                2.appendLine(builder, style.getTrailerFormat(), PrintFormat.HEADER_SESSION, PrintFormat.HEADER_ELAPSED_TIME, PrintFormat.HEADER_ELAPSED_TIME_ACC, PrintFormat.HEADER_COUNTER);
            }
            2.appendLine(builder, style.getAlternativeLine());
            return builder.toString();
        }

        private String toRowFormat(int sequence, Duration elapsedTime, Duration elapsedTimeAcc, PrintStyle style, Counter.Type type) {
            DurationFormat durationFormat = style.getDurationFormat();
            boolean printLegend = style.isPrintLegend();
            return String.format(style.getRowFormat(), sequence, durationFormat.format(elapsedTime, printLegend), durationFormat.format(elapsedTimeAcc, printLegend), style.getPrintableCounterName(type));
        }

        private String toTotalRowFormat(Duration elapsedTimeAcc, PrintStyle style) {
            return String.format(style.getSectionSummaryRowFormat(), style.getDurationFormat().format(elapsedTimeAcc, style.isPrintLegend()));
        }
    };

    static final String LINE_SEPARATOR;
    private static final String HEADER_SESSION = "#";
    private static final String HEADER_COUNTER = "Counter";
    private static final String HEADER_ELAPSED_TIME = "Elapsed time";
    private static final String HEADER_ELAPSED_TIME_ACC = "Elapsed time (+)";

    public abstract String format(TimingSessionContainer var1, PrintStyle var2);

    protected static void appendLine(StringBuilder builder, String string) {
        if (!PrintFormat.isEmpty(string)) {
            builder.append(string);
            builder.append(LINE_SEPARATOR);
        }
    }

    protected static void appendLine(StringBuilder builder, String format, Object ... args) {
        if (!PrintFormat.isEmpty(format)) {
            PrintFormat.appendLine(builder, String.format(format, args));
        }
    }

    private static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public void checkCompatibility(PrintStyle printStyle) {
        Objects.requireNonNull(printStyle, "The PrintStyle must not be null");
        if (printStyle.getPrintFormat() != this) {
            throw new IllegalArgumentException(String.format("Incompatible PrintStyle. Expected %s but received %s.", new Object[]{this, printStyle.getPrintFormat()}));
        }
    }

    static {
        LINE_SEPARATOR = System.getProperty("line.separator");
    }
}

