/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.util;

import java.util.Collection;
import net.obvj.performetrics.util.Duration;

public class DurationUtils {
    private DurationUtils() {
        throw new IllegalStateException("Instantiation not allowed");
    }

    public static Duration average(Collection<Duration> durations) {
        if (DurationUtils.isEmpty(durations)) {
            return Duration.ZERO;
        }
        Duration sum = Duration.ZERO;
        int count = 0;
        for (Duration element : durations) {
            if (element == null) continue;
            sum = sum.plus(element);
            ++count;
        }
        return count == 0 ? Duration.ZERO : sum.dividedBy(count);
    }

    public static Duration min(Collection<Duration> durations) {
        if (DurationUtils.isEmpty(durations)) {
            return Duration.ZERO;
        }
        return durations.stream().min(Comparable::compareTo).orElse(Duration.ZERO);
    }

    public static Duration max(Collection<Duration> durations) {
        if (DurationUtils.isEmpty(durations)) {
            return Duration.ZERO;
        }
        return durations.stream().max(Comparable::compareTo).orElse(Duration.ZERO);
    }

    private static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }
}

