/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.util;

import java.time.format.DateTimeParseException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.obvj.performetrics.util.Duration;

public enum DurationFormat {
    FULL{

        @Override
        public String doFormat(Duration duration, boolean printLegend) {
            StringBuilder buffer = new StringBuilder(32);
            DurationFormat.appendSign(buffer, duration);
            buffer.append(duration.getHours()).append(':').append(DurationFormat.formatTwoDigits(duration.getMinutes())).append(':').append(DurationFormat.formatTwoDigits(duration.getSeconds())).append('.').append(DurationFormat.formatNanoseconds(duration.getNanoseconds()));
            DurationFormat.appendlegend(buffer, printLegend, MyTimeUnit.HOURS);
            return buffer.toString();
        }

        @Override
        public Duration doParse(String string) {
            return DurationFormat.parseDurationHMS(string);
        }
    }
    ,
    SHORT{

        @Override
        public String doFormat(Duration duration, boolean printLegend) {
            MyTimeUnit timeUnit = MyTimeUnit.from(duration);
            if (timeUnit == MyTimeUnit.HOURS) {
                return FULL.doFormat(duration, printLegend);
            }
            StringBuilder buffer = new StringBuilder(32);
            DurationFormat.appendSign(buffer, duration);
            if (timeUnit == MyTimeUnit.MINUTES) {
                buffer.append(duration.getMinutes()).append(':').append(DurationFormat.formatTwoDigits(duration.getSeconds()));
            } else {
                buffer.append(duration.getSeconds());
            }
            buffer.append('.').append(DurationFormat.formatNanoseconds(duration.getNanoseconds()));
            DurationFormat.appendlegend(buffer, printLegend, timeUnit);
            return buffer.toString();
        }

        @Override
        public Duration doParse(String string) {
            return DurationFormat.parseDurationHMS(string);
        }
    }
    ,
    SHORTER{

        @Override
        public String doFormat(Duration duration, boolean printLegend) {
            String format = 3.removeTrailingZeros(SHORT.doFormat(duration, false));
            return printLegend ? format + " " + MyTimeUnit.from((Duration)duration).legend : format;
        }

        @Override
        public Duration doParse(String string) {
            return DurationFormat.parseDurationHMS(string);
        }
    }
    ,
    ISO_8601{

        @Override
        public String doFormat(Duration duration, boolean printLegend) {
            return duration.internal().toString();
        }

        @Override
        public Duration doParse(String string) {
            try {
                return new Duration(java.time.Duration.parse(string));
            }
            catch (DateTimeParseException exception) {
                throw new IllegalArgumentException(String.format(DurationFormat.MSG_UNPARSEABLE_DURATION, string), exception);
            }
        }
    }
    ,
    LINUX{
        private final Pattern linuxPattern = Pattern.compile("^(?<sign>-?)(?<minutes>\\d+)m(?<seconds>\\d+).(?<milliseconds>\\d+)s");

        @Override
        public String doFormat(Duration duration, boolean printLegend) {
            StringBuilder buffer = new StringBuilder(16);
            DurationFormat.appendSign(buffer, duration);
            buffer.append(TimeUnit.SECONDS.toMinutes(duration.effectiveTotalSeconds)).append('m').append(duration.getSeconds()).append('.').append(DurationFormat.formatMilliseconds(TimeUnit.NANOSECONDS.toMillis(duration.effectiveNanoseconds))).append('s');
            return buffer.toString();
        }

        @Override
        public Duration doParse(String string) {
            Matcher matcher = this.linuxPattern.matcher(string);
            if (matcher.matches()) {
                Duration duration = DurationFormat.parseDuration(matcher.group("minutes"), TimeUnit.MINUTES).plus(DurationFormat.parseDuration(matcher.group("seconds"), TimeUnit.SECONDS)).plus(DurationFormat.parseDuration(matcher.group("milliseconds"), TimeUnit.MILLISECONDS));
                if (matcher.group("sign").equals("-")) {
                    duration = duration.negated();
                }
                return duration;
            }
            throw new IllegalArgumentException(String.format(DurationFormat.MSG_UNPARSEABLE_DURATION, string));
        }
    };

    private static final Pattern HMS_PATTERN;
    private static final String TWO_DIGITS_FORMAT = "%02d";
    private static final String MILLIS_FORMAT = "%03d";
    private static final String NANOS_FORMAT = "%09d";
    static final String MSG_DURATION_MUST_NOT_BE_NULL = "The duration must not be null";
    static final String MSG_UNPARSEABLE_DURATION = "Unrecognized duration: %s";

    public String format(Duration duration, boolean printLegend) {
        Objects.requireNonNull(duration, MSG_DURATION_MUST_NOT_BE_NULL);
        return this.doFormat(duration, printLegend);
    }

    abstract String doFormat(Duration var1, boolean var2);

    public Duration parse(String string) {
        Objects.requireNonNull(string);
        return this.doParse(string);
    }

    abstract Duration doParse(String var1);

    private static void appendSign(StringBuilder buffer, Duration duration) {
        if (duration.isNegative()) {
            buffer.append('-');
        }
    }

    private static void appendlegend(StringBuilder buffer, boolean printLegend, MyTimeUnit timeUnit) {
        if (printLegend) {
            buffer.append(' ').append(timeUnit.legend);
        }
    }

    static String removeTrailingZeros(String string) {
        StringBuilder builder = new StringBuilder(string);
        while (builder.charAt(builder.length() - 1) == '0') {
            builder.setLength(builder.length() - 1);
        }
        if (builder.charAt(builder.length() - 1) == '.') {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    static String rightPadZeros(String string, int size) {
        if (string.length() >= size) {
            return string;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(string);
        builder.setLength(size);
        return builder.toString().replace('\u0000', '0');
    }

    private static Duration parseDurationHMS(String string) {
        Matcher matcher = HMS_PATTERN.matcher(string);
        if (matcher.matches()) {
            Duration duration = DurationFormat.parseDuration(matcher.group("hours"), TimeUnit.HOURS).plus(DurationFormat.parseDuration(matcher.group("minutes"), TimeUnit.MINUTES)).plus(DurationFormat.parseDuration(matcher.group("seconds"), TimeUnit.SECONDS)).plus(DurationFormat.parseNanoseconds(matcher.group("nanoseconds")));
            if (matcher.group("sign").equals("-")) {
                duration = duration.negated();
            }
            return duration;
        }
        throw new IllegalArgumentException(String.format(MSG_UNPARSEABLE_DURATION, string));
    }

    private static Duration parseDuration(String string, TimeUnit timeUnit) {
        if (string != null) {
            long value = Long.parseLong(string);
            return Duration.of(value, timeUnit);
        }
        return Duration.ZERO;
    }

    private static Duration parseNanoseconds(String string) {
        if (string != null) {
            String nanoseconds = DurationFormat.rightPadZeros(string, 9);
            return DurationFormat.parseDuration(nanoseconds, TimeUnit.NANOSECONDS);
        }
        return Duration.ZERO;
    }

    private static String formatTwoDigits(int value) {
        return String.format(TWO_DIGITS_FORMAT, value);
    }

    private static String formatMilliseconds(long value) {
        return String.format(MILLIS_FORMAT, value);
    }

    private static String formatNanoseconds(int value) {
        return String.format(NANOS_FORMAT, value);
    }

    static {
        HMS_PATTERN = Pattern.compile("^(?<sign>-?)(((?<hours>\\d*):)?((?<minutes>\\d*):))?(?<seconds>\\d+)([.,](?<nanoseconds>\\d+))?(.)*");
    }

    private static enum MyTimeUnit {
        HOURS("hour(s)"),
        MINUTES("minute(s)"),
        SECONDS("second(s)");

        private final String legend;

        private MyTimeUnit(String legend) {
            this.legend = legend;
        }

        private static MyTimeUnit from(Duration duration) {
            if (duration.getHours() != 0L) {
                return HOURS;
            }
            if (duration.getMinutes() != 0) {
                return MINUTES;
            }
            return SECONDS;
        }
    }
}

